/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.reflection;

import io.fluxcapacitor.common.reflection.MemberInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMemberInvoker
implements MemberInvoker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMemberInvoker.class);
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static final Map<Member, MemberInvoker> cache = new ConcurrentHashMap<Member, MemberInvoker>();
    private final Member member;
    private final BiFunction<Object, IntFunction<?>, Object> invokeFunction;
    private final FallbackFunction fallbackFunction;
    private final boolean staticMember;
    private final boolean returnsResult;
    private final int lambdaParameterCount;
    private final Class<?>[] parameterTypes;

    public static MemberInvoker asInvoker(Member member) {
        return DefaultMemberInvoker.asInvoker(member, true);
    }

    public static MemberInvoker asInvoker(Member member, boolean forceAccess) {
        return cache.computeIfAbsent(member, m -> new DefaultMemberInvoker((Member)m, forceAccess));
    }

    private DefaultMemberInvoker(Member member, boolean forceAccess) {
        if (forceAccess) {
            ReflectionUtils.ensureAccessible((AccessibleObject)((Object)member));
        }
        this.member = member;
        this.lambdaParameterCount = DefaultMemberInvoker.getLambdaParameterCount(member);
        this.parameterTypes = (Class[])Collections.nCopies(this.lambdaParameterCount, Object.class).toArray(Class[]::new);
        this.returnsResult = !(member instanceof Method) || !((Method)member).getReturnType().equals(Void.TYPE);
        this.staticMember = Modifier.isStatic(member.getModifiers()) || member instanceof Constructor;
        this.invokeFunction = this.computeInvokeFunction();
        this.fallbackFunction = this.invokeFunction == null ? this.computeFallbackFunction() : null;
    }

    @Override
    public Object invoke(Object target, int parameterCount, IntFunction<?> paramProvider) {
        if (!this.staticMember && target == null) {
            return null;
        }
        if (this.fallbackFunction != null) {
            return this.fallbackFunction.apply(target, parameterCount, paramProvider);
        }
        if (this.staticMember && parameterCount > 0) {
            return this.invokeFunction.apply(paramProvider.apply(0), i -> paramProvider.apply(i + 1));
        }
        return this.invokeFunction.apply(target, paramProvider);
    }

    private BiFunction<Object, IntFunction<?>, Object> computeInvokeFunction() {
        Executable e;
        if (this.member instanceof Field || Proxy.isProxyClass(this.member.getDeclaringClass())) {
            return null;
        }
        Member member = this.member;
        if (member instanceof Executable && Arrays.stream((e = (Executable)member).getParameterTypes()).anyMatch(Class::isPrimitive)) {
            return null;
        }
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(this.member.getDeclaringClass(), DefaultMemberInvoker.lookup);
            MethodHandle realMethodHandle = DefaultMemberInvoker.getMethodHandle(this.member, lookup);
            MethodType factoryType = MethodType.methodType(Class.forName(DefaultMemberInvoker.class.getName() + (this.returnsResult ? "$_Function" : "$_Consumer") + this.lambdaParameterCount));
            MethodType interfaceMethodType = MethodType.methodType(this.returnsResult ? Object.class : Void.TYPE, this.parameterTypes);
            CallSite site = LambdaMetafactory.metafactory(lookup, this.returnsResult ? "apply" : "accept", factoryType, interfaceMethodType, realMethodHandle, realMethodHandle.type());
            Object invokeFunction = site.getTarget().invoke();
            if (this.returnsResult) {
                switch (this.lambdaParameterCount) {
                    case 0: {
                        _Function0 delegate = (_Function0)invokeFunction;
                        return (target, paramProvider) -> delegate.apply();
                    }
                    case 1: {
                        _Function1 delegate = (_Function1)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target);
                    }
                    case 2: {
                        _Function2 delegate = (_Function2)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target, paramProvider.apply(0));
                    }
                    case 3: {
                        _Function3 delegate = (_Function3)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target, paramProvider.apply(0), paramProvider.apply(1));
                    }
                    case 4: {
                        _Function4 delegate = (_Function4)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2));
                    }
                    case 5: {
                        _Function5 delegate = (_Function5)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3));
                    }
                    case 6: {
                        _Function6 delegate = (_Function6)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4));
                    }
                    case 7: {
                        _Function7 delegate = (_Function7)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4), paramProvider.apply(5));
                    }
                    case 8: {
                        _Function8 delegate = (_Function8)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4), paramProvider.apply(5), paramProvider.apply(6));
                    }
                    case 9: {
                        _Function9 delegate = (_Function9)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4), paramProvider.apply(5), paramProvider.apply(6), paramProvider.apply(7));
                    }
                    case 10: {
                        _Function10 delegate = (_Function10)invokeFunction;
                        return (target, paramProvider) -> delegate.apply(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4), paramProvider.apply(5), paramProvider.apply(6), paramProvider.apply(7), paramProvider.apply(8));
                    }
                }
                throw new UnsupportedOperationException("Methods with more than 9 parameters aren't supported. Falling back on reflection.");
            }
            switch (this.lambdaParameterCount) {
                case 0: {
                    _Consumer0 delegate = (_Consumer0)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept();
                        return null;
                    };
                }
                case 1: {
                    _Consumer1 delegate = (_Consumer1)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target);
                        return null;
                    };
                }
                case 2: {
                    _Consumer2 delegate = (_Consumer2)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target, paramProvider.apply(0));
                        return null;
                    };
                }
                case 3: {
                    _Consumer3 delegate = (_Consumer3)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target, paramProvider.apply(0), paramProvider.apply(1));
                        return null;
                    };
                }
                case 4: {
                    _Consumer4 delegate = (_Consumer4)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2));
                        return null;
                    };
                }
                case 5: {
                    _Consumer5 delegate = (_Consumer5)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3));
                        return null;
                    };
                }
                case 6: {
                    _Consumer6 delegate = (_Consumer6)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4));
                        return null;
                    };
                }
                case 7: {
                    _Consumer7 delegate = (_Consumer7)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4), paramProvider.apply(5));
                        return null;
                    };
                }
                case 8: {
                    _Consumer8 delegate = (_Consumer8)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4), paramProvider.apply(5), paramProvider.apply(6));
                        return null;
                    };
                }
                case 9: {
                    _Consumer9 delegate = (_Consumer9)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4), paramProvider.apply(5), paramProvider.apply(6), paramProvider.apply(7));
                        return null;
                    };
                }
                case 10: {
                    _Consumer10 delegate = (_Consumer10)invokeFunction;
                    return (target, paramProvider) -> {
                        delegate.accept(target, paramProvider.apply(0), paramProvider.apply(1), paramProvider.apply(2), paramProvider.apply(3), paramProvider.apply(4), paramProvider.apply(5), paramProvider.apply(6), paramProvider.apply(7), paramProvider.apply(8));
                        return null;
                    };
                }
            }
            throw new UnsupportedOperationException("Methods with more than 9 parameters aren't supported. Falling back on reflection.");
        }
        catch (Exception e2) {
            log.warn("Failed to create lambda type method invoke", e2);
            return null;
        }
    }

    private static int getLambdaParameterCount(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getParameterCount() + (Modifier.isStatic(member.getModifiers()) ? 0 : 1);
        }
        if (member instanceof Field) {
            return Modifier.isStatic(member.getModifiers()) ? 0 : 1;
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).getParameterCount();
        }
        throw new UnsupportedOperationException("Member type not supported: " + String.valueOf(member.getClass()));
    }

    private static MethodHandle getMethodHandle(Member member, MethodHandles.Lookup lookup) throws IllegalAccessException {
        if (member instanceof Method) {
            return lookup.unreflect((Method)member);
        }
        if (member instanceof Field) {
            return lookup.unreflectGetter((Field)member);
        }
        if (member instanceof Constructor) {
            return lookup.unreflectConstructor((Constructor)member);
        }
        throw new UnsupportedOperationException("Member type not supported: " + String.valueOf(member.getClass()));
    }

    private FallbackFunction computeFallbackFunction() {
        Member member = this.member;
        if (member instanceof Method) {
            Method method = (Method)member;
            return (target, paramCount, paramSupplier) -> method.invoke(target, this.asArray(paramCount, paramSupplier));
        }
        member = this.member;
        if (member instanceof Field) {
            Field field = (Field)member;
            return (target, paramCount, paramSupplier) -> {
                if (paramCount == 0) {
                    return field.get(target);
                }
                field.set(target, paramSupplier.apply(0));
                return target;
            };
        }
        member = this.member;
        if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            return (target, paramCount, paramSupplier) -> constructor.newInstance(this.asArray(paramCount, paramSupplier));
        }
        throw new UnsupportedOperationException("Member type not supported: " + String.valueOf(this.member.getClass()));
    }

    private Object[] asArray(int paramCount, IntFunction<?> paramSupplier) {
        Object[] result = new Object[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            result[i] = paramSupplier.apply(i);
        }
        return result;
    }

    @Override
    @Generated
    public Member getMember() {
        return this.member;
    }

    @FunctionalInterface
    private static interface FallbackFunction {
        public Object apply(Object var1, int var2, IntFunction<?> var3) throws Throwable;
    }

    @FunctionalInterface
    public static interface _Function0 {
        public Object apply();
    }

    @FunctionalInterface
    public static interface _Function1 {
        public Object apply(Object var1);
    }

    @FunctionalInterface
    public static interface _Function2 {
        public Object apply(Object var1, Object var2);
    }

    @FunctionalInterface
    public static interface _Function3 {
        public Object apply(Object var1, Object var2, Object var3);
    }

    @FunctionalInterface
    public static interface _Function4 {
        public Object apply(Object var1, Object var2, Object var3, Object var4);
    }

    @FunctionalInterface
    public static interface _Function5 {
        public Object apply(Object var1, Object var2, Object var3, Object var4, Object var5);
    }

    @FunctionalInterface
    public static interface _Function6 {
        public Object apply(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6);
    }

    @FunctionalInterface
    public static interface _Function7 {
        public Object apply(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7);
    }

    @FunctionalInterface
    public static interface _Function8 {
        public Object apply(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8);
    }

    @FunctionalInterface
    public static interface _Function9 {
        public Object apply(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9);
    }

    @FunctionalInterface
    public static interface _Function10 {
        public Object apply(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10);
    }

    @FunctionalInterface
    public static interface _Consumer0 {
        public void accept();
    }

    @FunctionalInterface
    public static interface _Consumer1 {
        public void accept(Object var1);
    }

    @FunctionalInterface
    public static interface _Consumer2 {
        public void accept(Object var1, Object var2);
    }

    @FunctionalInterface
    public static interface _Consumer3 {
        public void accept(Object var1, Object var2, Object var3);
    }

    @FunctionalInterface
    public static interface _Consumer4 {
        public void accept(Object var1, Object var2, Object var3, Object var4);
    }

    @FunctionalInterface
    public static interface _Consumer5 {
        public void accept(Object var1, Object var2, Object var3, Object var4, Object var5);
    }

    @FunctionalInterface
    public static interface _Consumer6 {
        public void accept(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6);
    }

    @FunctionalInterface
    public static interface _Consumer7 {
        public void accept(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7);
    }

    @FunctionalInterface
    public static interface _Consumer8 {
        public void accept(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8);
    }

    @FunctionalInterface
    public static interface _Consumer9 {
        public void accept(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9);
    }

    @FunctionalInterface
    public static interface _Consumer10 {
        public void accept(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10);
    }
}

