/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.tracking;

import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.tracking.Tracker;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;

public final class SimpleTracker
implements Tracker {
    private final String consumerName;
    private final int maxSize;
    private final Consumer<MessageBatch> handler;
    private final long maxTimeout = 6000L;
    private final long deadline = System.currentTimeMillis() + 6000L;
    private final Long lastTrackerIndex;

    public SimpleTracker(String consumerName, int maxSize, Consumer<MessageBatch> handler) {
        this(consumerName, maxSize, handler, 0L);
    }

    @Override
    public boolean ignoreSegment() {
        return false;
    }

    @Override
    public boolean clientControlledIndex() {
        return false;
    }

    @Override
    public String getTrackerId() {
        return this.consumerName;
    }

    @Override
    public String getClientId() {
        return this.consumerName;
    }

    @Override
    public Long getPurgeDelay() {
        return null;
    }

    @Override
    public void send(MessageBatch batch) {
        this.handler.accept(batch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTracker that = (SimpleTracker)o;
        return Objects.equals(this.consumerName, that.consumerName);
    }

    public int hashCode() {
        return Objects.hash(this.consumerName);
    }

    public String toString() {
        return "SimpleTracker{consumerName='" + this.consumerName + "'}";
    }

    @Generated
    private static int $default$maxSize() {
        return 1024;
    }

    @Generated
    private static Long $default$lastTrackerIndex() {
        return 0L;
    }

    @Generated
    public static SimpleTrackerBuilder builder() {
        return new SimpleTrackerBuilder();
    }

    @Generated
    public SimpleTrackerBuilder toBuilder() {
        return new SimpleTrackerBuilder().consumerName(this.consumerName).maxSize(this.maxSize).handler(this.handler).lastTrackerIndex(this.lastTrackerIndex);
    }

    @Override
    @Generated
    public String getConsumerName() {
        return this.consumerName;
    }

    @Override
    @Generated
    public int getMaxSize() {
        return this.maxSize;
    }

    @Generated
    public Consumer<MessageBatch> getHandler() {
        return this.handler;
    }

    @Override
    @Generated
    public long maxTimeout() {
        return this.maxTimeout;
    }

    @Override
    @Generated
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    @Generated
    public Long getLastTrackerIndex() {
        return this.lastTrackerIndex;
    }

    @ConstructorProperties(value={"consumerName", "maxSize", "handler", "lastTrackerIndex"})
    @Generated
    public SimpleTracker(String consumerName, int maxSize, Consumer<MessageBatch> handler, Long lastTrackerIndex) {
        this.consumerName = consumerName;
        this.maxSize = maxSize;
        this.handler = handler;
        this.lastTrackerIndex = lastTrackerIndex;
    }

    @Override
    @Generated
    public SimpleTracker withLastTrackerIndex(Long lastTrackerIndex) {
        return this.lastTrackerIndex == lastTrackerIndex ? this : new SimpleTracker(this.consumerName, this.maxSize, this.handler, lastTrackerIndex);
    }

    @Generated
    public static class SimpleTrackerBuilder {
        @Generated
        private String consumerName;
        @Generated
        private boolean maxSize$set;
        @Generated
        private int maxSize$value;
        @Generated
        private Consumer<MessageBatch> handler;
        @Generated
        private boolean lastTrackerIndex$set;
        @Generated
        private Long lastTrackerIndex$value;

        @Generated
        SimpleTrackerBuilder() {
        }

        @Generated
        public SimpleTrackerBuilder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        @Generated
        public SimpleTrackerBuilder maxSize(int maxSize) {
            this.maxSize$value = maxSize;
            this.maxSize$set = true;
            return this;
        }

        @Generated
        public SimpleTrackerBuilder handler(Consumer<MessageBatch> handler) {
            this.handler = handler;
            return this;
        }

        @Generated
        public SimpleTrackerBuilder lastTrackerIndex(Long lastTrackerIndex) {
            this.lastTrackerIndex$value = lastTrackerIndex;
            this.lastTrackerIndex$set = true;
            return this;
        }

        @Generated
        public SimpleTracker build() {
            int maxSize$value = this.maxSize$value;
            if (!this.maxSize$set) {
                maxSize$value = SimpleTracker.$default$maxSize();
            }
            Long lastTrackerIndex$value = this.lastTrackerIndex$value;
            if (!this.lastTrackerIndex$set) {
                lastTrackerIndex$value = SimpleTracker.$default$lastTrackerIndex();
            }
            return new SimpleTracker(this.consumerName, maxSize$value, this.handler, lastTrackerIndex$value);
        }

        @Generated
        public String toString() {
            return "SimpleTracker.SimpleTrackerBuilder(consumerName=" + this.consumerName + ", maxSize$value=" + this.maxSize$value + ", handler=" + String.valueOf(this.handler) + ", lastTrackerIndex$value=" + this.lastTrackerIndex$value + ")";
        }
    }
}

