/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.tracking;

import io.fluxcapacitor.common.ConsistentHashing;
import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import java.util.Comparator;
import java.util.function.Predicate;

public interface Tracker
extends Comparable<Tracker> {
    public static final Comparator<Tracker> comparator = Comparator.comparing(Tracker::getConsumerName).thenComparing(Tracker::getTrackerId);

    public String getConsumerName();

    default public void sendEmptyBatch(MessageBatch batch) {
        this.send(batch);
    }

    public void send(MessageBatch var1);

    default public boolean canHandle(SerializedMessage message, int[] segmentRange) {
        return this.isValidTarget(message, segmentRange) && this.isValidType(message);
    }

    private boolean isValidTarget(SerializedMessage message, int[] segmentRange) {
        String target = message.getTarget();
        if (this.isFilterMessageTarget() && target != null) {
            if (target.equals(this.getTrackerId())) {
                return true;
            }
            if (!target.equals(this.getClientId())) {
                return false;
            }
        }
        return this.contains(message, segmentRange);
    }

    private boolean contains(SerializedMessage message, int[] segmentRange) {
        if (this.singleTracker()) {
            return segmentRange[0] == 0 && segmentRange[0] != segmentRange[1];
        }
        if (this.ignoreSegment()) {
            return true;
        }
        return ConsistentHashing.fallsInRange(message.getSegment(), segmentRange);
    }

    private boolean isValidType(SerializedMessage message) {
        return message.getData().getType() == null || this.getTypeFilter().test(message.getData().getType());
    }

    public String getClientId();

    default public Predicate<String> getTypeFilter() {
        return s -> true;
    }

    default public boolean singleTracker() {
        return false;
    }

    default public boolean isFilterMessageTarget() {
        return false;
    }

    public boolean ignoreSegment();

    public boolean clientControlledIndex();

    public String getTrackerId();

    public Long getLastTrackerIndex();

    public long getDeadline();

    public long maxTimeout();

    default public boolean hasMissedDeadline() {
        return TimingUtils.isMissedDeadline(this.getDeadline());
    }

    public Long getPurgeDelay();

    public int getMaxSize();

    public Tracker withLastTrackerIndex(Long var1);

    @Override
    default public int compareTo(Tracker o) {
        return comparator.compare(this, o);
    }
}

