/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.tracking;

import io.fluxcapacitor.common.tracking.Tracker;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class TrackerCluster {
    public static final int[] emptyRange = new int[]{0, 0};
    private final int segments;
    private final Map<Tracker, Segment> trackers;
    private final Map<Tracker, Instant> activeTrackers;

    public TrackerCluster(int segments) {
        this(segments, Collections.emptyMap(), Collections.emptyMap());
    }

    private TrackerCluster(int segments, Map<Tracker, Segment> trackers, Map<Tracker, Instant> activeTrackers) {
        this.segments = segments;
        this.trackers = trackers;
        this.activeTrackers = activeTrackers;
    }

    public TrackerCluster withActiveTracker(Tracker tracker) {
        if (!this.contains(tracker) || this.isActive(tracker)) {
            return this.withWaitingTracker(tracker).withActiveTracker(tracker);
        }
        HashMap<Tracker, Instant> activeTrackers = new HashMap<Tracker, Instant>(this.activeTrackers);
        activeTrackers.putIfAbsent(tracker, Instant.now());
        return new TrackerCluster(this.segments, this.trackers, activeTrackers);
    }

    public TrackerCluster withWaitingTracker(Tracker tracker) {
        SortedSet trackers = Stream.concat(this.trackers.keySet().stream().filter(c -> !c.equals(tracker)), Stream.of(tracker)).collect(Collectors.toCollection(TreeSet::new));
        HashMap<Tracker, Instant> activeTrackers = new HashMap<Tracker, Instant>(this.activeTrackers);
        activeTrackers.remove(tracker);
        return this.recalculate(trackers, activeTrackers);
    }

    public TrackerCluster withoutTracker(Tracker tracker) {
        if (!this.contains(tracker)) {
            return this;
        }
        SortedSet trackers = this.trackers.keySet().stream().filter(c -> !c.equals(tracker)).collect(Collectors.toCollection(TreeSet::new));
        HashMap<Tracker, Instant> activeTrackers = new HashMap<Tracker, Instant>(this.activeTrackers);
        activeTrackers.remove(tracker);
        return this.recalculate(trackers, activeTrackers);
    }

    public TrackerCluster purgeTrackers(Predicate<Tracker> predicate) {
        TrackerCluster result = this;
        for (Tracker tracker : this.trackers.keySet()) {
            if (!predicate.test(tracker)) continue;
            result = result.withoutTracker(tracker);
        }
        return result;
    }

    public TrackerCluster purgeCeasedTrackers(Instant threshold) {
        return this.purgeTrackers(t -> Optional.ofNullable(this.activeTrackers.get(t)).filter(p -> p.isBefore(threshold)).isPresent());
    }

    public Optional<Duration> getProcessingDuration(Tracker tracker) {
        return Optional.ofNullable(this.activeTrackers.get(tracker)).map(t -> Duration.between(t, Instant.now()));
    }

    public int[] getSegment(Tracker tracker) {
        return Optional.ofNullable(this.trackers.get(tracker)).map(segment -> {
            if (tracker.singleTracker()) {
                int[] nArray;
                if (segment.contains(0) && segment.getLength() > 0) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = 0;
                    nArray = nArray2;
                    nArray2[1] = this.segments;
                } else {
                    nArray = emptyRange;
                }
                return nArray;
            }
            return segment.asArray();
        }).orElse(null);
    }

    public boolean contains(Tracker tracker) {
        return this.trackers.containsKey(tracker);
    }

    public boolean isActive(Tracker tracker) {
        return this.activeTrackers.containsKey(tracker);
    }

    public Set<Tracker> getTrackers() {
        return Collections.unmodifiableSet(this.trackers.keySet());
    }

    public boolean isEmpty() {
        return this.trackers.isEmpty();
    }

    private TrackerCluster recalculate(SortedSet<Tracker> trackers, Map<Tracker, Instant> activeTrackers) {
        if (trackers.isEmpty()) {
            return new TrackerCluster(this.segments);
        }
        Map<Tracker, Segment> constraints = activeTrackers.keySet().stream().filter(c -> !Objects.equals(this.trackers.get(c), new Segment(0, 0))).collect(Collectors.toMap(Function.identity(), this.trackers::get));
        TreeSet<Integer> grid = TrackerCluster.createGrid(this.segments, trackers.size(), constraints.values());
        TrackerCluster.removeGridPoints(grid, trackers.size(), Stream.concat(Stream.of(0, this.segments), TrackerCluster.getIntersections(constraints.values()).stream()).collect(Collectors.toSet()));
        List<Segment> trackerSegments = TrackerCluster.toSegments(grid);
        Map<Tracker, Segment> adjustedConstraints = this.adjustConstraints(trackerSegments, constraints);
        TreeMap<Tracker, Segment> listeningTrackers = new TreeMap<Tracker, Segment>(adjustedConstraints);
        ArrayList<Segment> remainingSegments = new ArrayList<Segment>(trackerSegments);
        remainingSegments.removeAll(listeningTrackers.values());
        trackers.stream().filter(t -> !adjustedConstraints.containsKey(t)).forEach(t -> listeningTrackers.put((Tracker)t, remainingSegments.isEmpty() ? new Segment(0, 0) : (Segment)remainingSegments.remove(0)));
        return new TrackerCluster(this.segments, listeningTrackers, activeTrackers);
    }

    private Map<Tracker, Segment> adjustConstraints(List<Segment> segments, Map<Tracker, Segment> constraints) {
        HashMap<Tracker, Segment> result = new HashMap<Tracker, Segment>();
        constraints.forEach((tracker, segment) -> segments.stream().filter(newSegment -> newSegment.contains(segment.getStart())).findAny().ifPresent(newSegment -> result.put((Tracker)tracker, (Segment)newSegment)));
        return result;
    }

    private static TreeSet<Integer> createGrid(int segments, int trackers, Collection<Segment> constraints) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        int quotient = segments / trackers;
        int remainder = segments % trackers;
        result.add(0);
        int last = 0;
        for (int i = 1; i <= trackers; ++i) {
            result.add(last += trackers - i < remainder ? quotient + 1 : quotient);
        }
        constraints.forEach(segment -> Collections.addAll(result, segment.getStart(), segment.getEnd()));
        result.removeIf(point -> constraints.stream().anyMatch(segment -> point > segment.getStart() && point < segment.getEnd()));
        return result;
    }

    private static void removeGridPoints(TreeSet<Integer> grid, int trackers, Set<Integer> constraints) {
        while (grid.size() > trackers + 1) {
            ArrayList<Segment> segments = new ArrayList<Segment>();
            Iterator<Integer> iterator2 = grid.iterator();
            int start = iterator2.next();
            while (iterator2.hasNext()) {
                int end2 = iterator2.next();
                segments.add(new Segment(start, end2));
                start = end2;
            }
            segments.stream().sorted(Comparator.comparing(Segment::getLength)).map(Segment::getEnd).filter(end -> !constraints.contains(end)).findFirst().ifPresent(grid::remove);
        }
    }

    private static List<Segment> toSegments(SortedSet<Integer> grid) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        Iterator iterator2 = grid.iterator();
        int next = (Integer)iterator2.next();
        while (iterator2.hasNext()) {
            int n = next;
            next = (Integer)iterator2.next();
            result.add(new Segment(n, next));
        }
        return result;
    }

    private static Set<Integer> getIntersections(Collection<Segment> segments) {
        HashSet<Integer> result = new HashSet<Integer>();
        segments.stream().sorted(Comparator.comparing(Segment::getStart)).reduce((a, b) -> {
            if (a.getEnd() == b.getStart()) {
                result.add(a.getEnd());
            }
            return b;
        });
        return result;
    }

    @Generated
    public Map<Tracker, Instant> getActiveTrackers() {
        return this.activeTrackers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackerCluster)) {
            return false;
        }
        TrackerCluster other = (TrackerCluster)o;
        if (this.getSegments() != other.getSegments()) {
            return false;
        }
        Set<Tracker> this$trackers = this.getTrackers();
        Set<Tracker> other$trackers = other.getTrackers();
        if (this$trackers == null ? other$trackers != null : !((Object)this$trackers).equals(other$trackers)) {
            return false;
        }
        Map<Tracker, Instant> this$activeTrackers = this.getActiveTrackers();
        Map<Tracker, Instant> other$activeTrackers = other.getActiveTrackers();
        return !(this$activeTrackers == null ? other$activeTrackers != null : !((Object)this$activeTrackers).equals(other$activeTrackers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSegments();
        Set<Tracker> $trackers = this.getTrackers();
        result = result * 59 + ($trackers == null ? 43 : ((Object)$trackers).hashCode());
        Map<Tracker, Instant> $activeTrackers = this.getActiveTrackers();
        result = result * 59 + ($activeTrackers == null ? 43 : ((Object)$activeTrackers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TrackerCluster(segments=" + this.getSegments() + ", trackers=" + String.valueOf(this.getTrackers()) + ", activeTrackers=" + String.valueOf(this.getActiveTrackers()) + ")";
    }

    @Generated
    public int getSegments() {
        return this.segments;
    }

    static final class Segment {
        private final int start;
        private final int end;

        public Segment(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getLength() {
            return this.end - this.start;
        }

        public boolean contains(int point) {
            return point >= this.start && point < this.end;
        }

        public int[] asArray() {
            return new int[]{this.start, this.end};
        }

        @Generated
        public int getStart() {
            return this.start;
        }

        @Generated
        public int getEnd() {
            return this.end;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Segment)) {
                return false;
            }
            Segment other = (Segment)o;
            if (this.getStart() != other.getStart()) {
                return false;
            }
            return this.getEnd() == other.getEnd();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStart();
            result = result * 59 + this.getEnd();
            return result;
        }

        @Generated
        public String toString() {
            return "TrackerCluster.Segment(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }
}

