/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.casting;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.serialization.Converter;
import io.fluxcapacitor.javaclient.common.serialization.DeserializationException;
import io.fluxcapacitor.javaclient.common.serialization.casting.AnnotatedCaster;
import io.fluxcapacitor.javaclient.common.serialization.casting.CastInspector;
import io.fluxcapacitor.javaclient.common.serialization.casting.CastParameters;
import io.fluxcapacitor.javaclient.common.serialization.casting.Caster;
import io.fluxcapacitor.javaclient.common.serialization.casting.Downcast;
import io.fluxcapacitor.javaclient.common.serialization.casting.HasSource;
import io.fluxcapacitor.javaclient.common.serialization.casting.Upcast;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class DefaultCasterChain<T> {
    private static final Comparator<AnnotatedCaster<?>> upcasterComparator = Comparator.comparing(u -> u.getParameters().revision()).thenComparing(u -> u.getParameters().type());
    private static final Comparator<AnnotatedCaster<?>> downcasterComparator = Comparator.comparing(u -> u.getParameters().revision()).reversed().thenComparing(u -> u.getParameters().type());
    private final Map<DataRevision, AnnotatedCaster<T>> casters;
    private final boolean down;

    public static <T> Caster<SerializedObject<byte[], ?>, SerializedObject<?, ?>> createUpcaster(Collection<?> casterCandidates, Converter<byte[], T> converter) {
        Caster casterChain = DefaultCasterChain.create(casterCandidates, converter.getOutputType(), false);
        return (stream, desiredRevision) -> {
            Stream<ConvertingSerializedObject> converted = stream.map(s -> new ConvertingSerializedObject(s, converter));
            Stream casted = casterChain.cast(converted);
            return casted.map(ConvertingSerializedObject::getResult);
        };
    }

    public static <T, S extends SerializedObject<T, S>> Caster<S, S> create(Collection<?> casterCandidates, Class<T> dataType, boolean down) {
        List<AnnotatedCaster<T>> upcasterList = CastInspector.getCasters(down ? Downcast.class : Upcast.class, casterCandidates, dataType, down ? downcasterComparator : upcasterComparator);
        DefaultCasterChain<T> casterChain = new DefaultCasterChain<T>(upcasterList, down);
        return casterChain::cast;
    }

    protected DefaultCasterChain(Collection<AnnotatedCaster<T>> casters, boolean down) {
        this.casters = casters.stream().collect(Collectors.toMap(u -> new DataRevision(u.getParameters()), Function.identity(), (a, b) -> {
            throw new DeserializationException(String.format("Failed to create caster chain. Methods '%s' and '%s' both apply to the same data revision.", a, b));
        }));
        this.down = down;
    }

    protected <S extends SerializedObject<T, S>> Stream<S> cast(Stream<S> input, Integer desiredRevision) {
        return this.doCast(input, desiredRevision);
    }

    protected <S extends SerializedObject<T, S>> Stream<S> doCast(Stream<S> input, Integer desiredRevision) {
        return input.flatMap(i -> {
            boolean completed = desiredRevision != null && (this.down ? i.getRevision() <= desiredRevision : i.getRevision() >= desiredRevision);
            return completed ? Stream.of(i) : Optional.ofNullable(this.casters.get(new DataRevision(i.getType(), i.getRevision()))).map(caster -> this.doCast(caster.cast(i), desiredRevision)).orElseGet(() -> Stream.of(i));
        });
    }

    protected static final class DataRevision {
        private final String type;
        private final int revision;

        DataRevision(CastParameters annotation) {
            this(annotation.type(), annotation.revision());
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public int getRevision() {
            return this.revision;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataRevision)) {
                return false;
            }
            DataRevision other = (DataRevision)o;
            if (this.getRevision() != other.getRevision()) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRevision();
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultCasterChain.DataRevision(type=" + this.getType() + ", revision=" + this.getRevision() + ")";
        }

        @ConstructorProperties(value={"type", "revision"})
        @Generated
        public DataRevision(String type, int revision) {
            this.type = type;
            this.revision = revision;
        }
    }

    protected static class ConvertingSerializedObject<I, O>
    implements SerializedObject<O, ConvertingSerializedObject<I, O>>,
    HasSource<SerializedObject<I, ?>> {
        private final SerializedObject<I, ?> source;
        private final Converter<I, O> converter;
        private Data<O> data;

        public ConvertingSerializedObject(SerializedObject<I, ?> source, Converter<I, O> converter) {
            this.source = source;
            this.converter = converter;
        }

        @Override
        public Data<O> data() {
            if (this.data == null) {
                this.data = this.converter.convert(this.source.data());
            }
            return this.data;
        }

        @Override
        public String getType() {
            return this.data == null ? this.source.getType() : this.data.getType();
        }

        @Override
        public int getRevision() {
            return this.data == null ? this.source.getRevision() : this.data.getRevision();
        }

        public SerializedObject<?, ?> getResult() {
            if (this.data == null) {
                Data<?> converted = this.converter.convertFormat(this.source.data());
                return converted == this.source.data() ? this.source : this.source.withData(converted);
            }
            return this.source.withData(this.data);
        }

        @ConstructorProperties(value={"source", "converter", "data"})
        @Generated
        public ConvertingSerializedObject(SerializedObject<I, ?> source, Converter<I, O> converter, Data<O> data) {
            this.source = source;
            this.converter = converter;
            this.data = data;
        }

        @Override
        @Generated
        public SerializedObject<I, ?> getSource() {
            return this.source;
        }

        @Override
        @Generated
        public ConvertingSerializedObject<I, O> withData(Data<O> data) {
            return this.data == data ? this : new ConvertingSerializedObject<I, O>(this.source, this.converter, data);
        }
    }
}

