/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ServicePathBuilder;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class ServiceUrlBuilder {
    public static String producerUrl(MessageType messageType, String topic, WebSocketClient.ClientConfig clientConfig) {
        Object url = ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.producerPath(messageType));
        if (topic != null) {
            url = (String)url + "&topic=" + URLEncoder.encode(topic, StandardCharsets.UTF_8);
        }
        return url;
    }

    public static String consumerUrl(MessageType messageType, String topic, WebSocketClient.ClientConfig clientConfig) {
        Object url = ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.consumerPath(messageType));
        if (topic != null) {
            url = (String)url + "&topic=" + URLEncoder.encode(topic, StandardCharsets.UTF_8);
        }
        if (clientConfig.getTypeFilter() != null) {
            url = (String)url + "&typeFilter=" + clientConfig.getTypeFilter();
        }
        return url;
    }

    public static String eventSourcingUrl(WebSocketClient.ClientConfig clientConfig) {
        return ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.eventSourcingPath());
    }

    public static String keyValueUrl(WebSocketClient.ClientConfig clientConfig) {
        return ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.keyValuePath());
    }

    public static String searchUrl(WebSocketClient.ClientConfig clientConfig) {
        return ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.searchPath());
    }

    public static String schedulingUrl(WebSocketClient.ClientConfig clientConfig) {
        return ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.schedulingPath());
    }

    public static String buildUrl(WebSocketClient.ClientConfig clientConfig, String path) {
        String result = String.format("%s/%s?clientId=%s&clientName=%s", clientConfig.getServiceBaseUrl(), path, URLEncoder.encode(clientConfig.getId(), StandardCharsets.UTF_8), URLEncoder.encode(clientConfig.getName(), StandardCharsets.UTF_8));
        if (clientConfig.getProjectId() != null) {
            result = String.format("%s&projectId=%s", result, URLEncoder.encode(clientConfig.getProjectId(), StandardCharsets.UTF_8));
        }
        result = String.format("%s&compression=%s", new Object[]{result, clientConfig.getCompression()});
        return result;
    }
}

