/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.spring;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Conditional(value={Condition.class})
public @interface ConditionalOnBean {
    public Class<?> value();

    @Order
    public static class Condition
    implements ConfigurationCondition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Class type = (Class)metadata.getAllAnnotationAttributes(ConditionalOnBean.class.getName()).getFirst((Object)"value");
            return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), (Class)type).length != 0;
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }
    }
}

