/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.reflection.DefaultMemberInvoker;
import io.fluxcapacitor.common.reflection.MemberInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityHelper;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.modeling.ImmutableEntity;
import io.fluxcapacitor.javaclient.modeling.Member;
import java.beans.ConstructorProperties;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedEntityHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnnotatedEntityHolder.class);
    private static final Map<AccessibleObject, AnnotatedEntityHolder> cache = new ConcurrentHashMap<AccessibleObject, AnnotatedEntityHolder>();
    private static final Pattern getterPattern = Pattern.compile("(get|is)([A-Z].*)");
    private final AccessibleObject location;
    private final BiFunction<Object, Object, Object> wither;
    private final Class<?> holderType;
    private final Function<Object, Id> idProvider;
    private final Class<?> entityType;
    private final EntityHelper entityHelper;
    private final Serializer serializer;
    private final AtomicReference<Object> emptyEntity = new AtomicReference();
    private static final Function<Class<?>, Optional<MemberInvoker>> entityIdInvokerCache = ObjectUtils.memoize(entityType -> ReflectionUtils.getAnnotatedProperty(entityType, EntityId.class).map(a -> DefaultMemberInvoker.asInvoker((java.lang.reflect.Member)((Object)a))));

    public static AnnotatedEntityHolder getEntityHolder(Class<?> ownerType, AccessibleObject location, EntityHelper entityHelper, Serializer serializer) {
        return cache.computeIfAbsent(location, l -> new AnnotatedEntityHolder(ownerType, (AccessibleObject)l, entityHelper, serializer));
    }

    private AnnotatedEntityHolder(Class<?> ownerType, AccessibleObject location, EntityHelper entityHelper, Serializer serializer) {
        this.entityHelper = entityHelper;
        this.serializer = serializer;
        this.location = location;
        this.holderType = ReflectionUtils.getPropertyType(location);
        this.entityType = ReflectionUtils.getCollectionElementType(location).orElse(this.holderType);
        Member member = location.getAnnotation(Member.class);
        String pathToId = member.idProperty();
        this.idProvider = pathToId.isBlank() ? v -> (v == null ? Optional.empty() : entityIdInvokerCache.apply(v.getClass())).map(p -> new Id(p.invoke(v), p.getMember().getName())).orElseGet(() -> {
            Class<?> patt0$temp = ReflectionUtils.ifClass(v);
            if (patt0$temp instanceof Class) {
                Class<?> c = patt0$temp;
                return new Id(null, ReflectionUtils.getAnnotatedProperty(c, EntityId.class).map(ReflectionUtils::getName).orElse(null));
            }
            return new Id(null, null);
        }) : v -> new Id(ReflectionUtils.readProperty(pathToId, v).orElse(null), pathToId);
        this.wither = AnnotatedEntityHolder.computeWither(ownerType, location, serializer, member);
    }

    private static BiFunction<Object, Object, Object> computeWither(Class<?> ownerType, AccessibleObject location, Serializer serializer, Member member) {
        String propertyName = Introspector.decapitalize(Optional.of(ReflectionUtils.getName(location)).map(name -> Optional.of(getterPattern.matcher((CharSequence)name)).map(matcher -> matcher.matches() ? matcher.group(2) : name).orElse((String)name)).orElseThrow());
        Class[] witherParams = new Class[]{ReflectionUtils.getPropertyType(location)};
        Stream<Method> witherCandidates = ReflectionUtils.getAllMethods(ownerType).stream().filter(m -> m.getReturnType().isAssignableFrom(ownerType) || m.getReturnType().equals(Void.TYPE));
        witherCandidates = member.wither().isBlank() ? witherCandidates.filter(m -> Arrays.equals(witherParams, m.getParameterTypes()) && m.getName().toLowerCase().contains(propertyName.toLowerCase())) : witherCandidates.filter(m -> Objects.equals(member.wither(), m.getName()));
        Optional<BiFunction> wither = witherCandidates.findFirst().map(m -> (o, h) -> ObjectUtils.call(() -> m.invoke(o, h)));
        return wither.orElseGet(() -> {
            AtomicBoolean warningIssued = new AtomicBoolean();
            MemberInvoker field = ReflectionUtils.getField(ownerType, propertyName).map(DefaultMemberInvoker::asInvoker).orElse(null);
            return (o, h) -> {
                block6: {
                    if (warningIssued.get()) {
                        return o;
                    }
                    if (field == null) {
                        if (warningIssued.compareAndSet(false, true)) {
                            log.warn("No update function found for @Member {}. Updates to enclosed entities won't automatically update the parent entity.", (Object)location);
                        }
                    } else {
                        try {
                            o = serializer.clone(o);
                            field.invoke(o, h);
                        }
                        catch (Exception e) {
                            if (!warningIssued.compareAndSet(false, true)) break block6;
                            log.warn("Not able to update @Member {}. Please add a wither or setter method.", (Object)location, (Object)e);
                        }
                    }
                }
                return o;
            };
        });
    }

    public Stream<? extends ImmutableEntity<?>> getEntities(Entity<?> parent) {
        if (parent.get() == null) {
            return Stream.empty();
        }
        Object holderValue = ReflectionUtils.getValue(this.location, parent.get(), false);
        Class<?> type = holderValue == null ? this.holderType : holderValue.getClass();
        Object emptyEntity = ((ImmutableEntity.ImmutableEntityBuilder)this.getEmptyEntity().toBuilder().parent(parent)).build();
        if (holderValue == null) {
            return Stream.of(emptyEntity);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return Stream.concat(((Collection)holderValue).stream().map(v -> this.createEntity(v, this.idProvider, parent).orElse(null)).filter(Objects::nonNull), Stream.of(emptyEntity));
        }
        if (Map.class.isAssignableFrom(type)) {
            return Stream.concat(((Map)holderValue).entrySet().stream().flatMap(e -> this.createEntity(e.getValue(), v -> new Id(e.getKey(), this.idProvider.apply(v).property()), parent).stream()), Stream.of(emptyEntity));
        }
        return this.createEntity(holderValue, this.idProvider, parent).stream();
    }

    private Optional<ImmutableEntity<?>> createEntity(Object member, Function<Object, Id> idProvider, Entity<?> parent) {
        if (member == null) {
            return Optional.empty();
        }
        Id id = idProvider.apply(member);
        return Optional.of(((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)ImmutableEntity.builder().id(id.value())).type(member.getClass())).value((Object)member)).idProperty(id.property())).parent(parent)).holder(this)).entityHelper(this.entityHelper)).serializer(this.serializer)).build());
    }

    public Object updateOwner(Object owner, Entity<?> before, Entity<?> after) {
        Object holder = ReflectionUtils.getValue(this.location, owner);
        if (Collection.class.isAssignableFrom(this.holderType)) {
            ArrayList collection = (ArrayList)this.serializer.clone(holder);
            if (collection == null) {
                collection = new ArrayList();
            }
            if (collection instanceof List) {
                List list = collection;
                int index = list.indexOf(before.get());
                if (index < 0) {
                    list.add(after.get());
                } else if (after.get() == null) {
                    list.remove(index);
                } else {
                    list.set(index, after.get());
                }
                holder = list;
            } else {
                collection.remove(before.get());
                collection.add(after.get());
                holder = collection;
            }
        } else if (Map.class.isAssignableFrom(this.holderType)) {
            LinkedHashMap map = (LinkedHashMap)this.serializer.clone(holder);
            if (map == null) {
                map = new LinkedHashMap();
            }
            Object id = Optional.ofNullable(after.id()).orElseGet(() -> this.idProvider.apply(after.get()).value());
            if (after.get() == null) {
                map.remove(id);
            } else {
                map.put(id, after.get());
            }
            holder = map;
        } else {
            holder = after.get();
        }
        Object result = this.wither.apply(owner, holder);
        return result == null ? owner : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public ImmutableEntity<?> getEmptyEntity() {
        Object $value = this.emptyEntity.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.emptyEntity;
            synchronized (atomicReference) {
                $value = this.emptyEntity.get();
                if ($value == null) {
                    Object actualValue = ((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableEntity.ImmutableEntityBuilder)ImmutableEntity.builder().type(this.entityType)).entityHelper(this.entityHelper)).serializer(this.serializer)).holder(this)).idProperty(this.idProvider.apply(this.entityType).property())).build();
                    $value = actualValue == null ? this.emptyEntity : actualValue;
                    this.emptyEntity.set($value);
                }
            }
        }
        return (ImmutableEntity)($value == this.emptyEntity ? null : $value);
    }

    private static final class Id {
        private final Object value;
        private final String property;

        @ConstructorProperties(value={"value", "property"})
        @Generated
        public Id(Object value, String property) {
            this.value = value;
            this.property = property;
        }

        @Generated
        public Object value() {
            return this.value;
        }

        @Generated
        public String property() {
            return this.property;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            Object this$value = this.value();
            Object other$value = other.value();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$property = this.property();
            String other$property = other.property();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $value = this.value();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $property = this.property();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AnnotatedEntityHolder.Id(value=" + String.valueOf(this.value()) + ", property=" + this.property() + ")";
        }
    }
}

