/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.api.search.BulkUpdate;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.common.api.search.bulkupdate.DeleteDocument;
import io.fluxcapacitor.common.api.search.bulkupdate.IndexDocument;
import io.fluxcapacitor.javaclient.common.Entry;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.DefaultHandlerRepository;
import io.fluxcapacitor.javaclient.modeling.HandlerRepository;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.Generated;

public class BatchingHandlerRepository
implements HandlerRepository {
    private final DefaultHandlerRepository delegate;
    private final DocumentSerializer documentSerializer;

    @Override
    public Collection<? extends Entry<?>> findByAssociation(Map<Object, String> associations) {
        if (associations.isEmpty()) {
            return Collections.emptyList();
        }
        SearchQuery query = SearchQuery.builder().constraint(this.delegate.asConstraint(associations)).collection(this.delegate.getCollection()).build();
        return Stream.concat(this.updates().values().stream().filter(u -> query.matches(u.getDocument())), this.removeOutdatedValues(this.delegate.findByAssociation(associations))).toList();
    }

    @Override
    public Collection<? extends Entry<?>> getAll() {
        return Stream.concat(this.updates().values().stream(), this.removeOutdatedValues(this.delegate.getAll())).toList();
    }

    protected Stream<? extends Entry<?>> removeOutdatedValues(Collection<? extends Entry<?>> delegateResult) {
        Map<Object, Update> updates = this.updates();
        return delegateResult.stream().filter(e -> !updates.containsKey(e.getId()));
    }

    @Override
    public CompletableFuture<?> put(Object id, Object value) {
        if (DeserializingMessage.getCurrent() == null) {
            return value == null ? this.delegate.delete(id) : this.delegate.put(id, value);
        }
        this.updates().put(id.toString(), new Update(id.toString(), value));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<?> delete(Object id) {
        return this.put(id, null);
    }

    protected Map<Object, Update> updates() {
        return DeserializingMessage.computeForBatchIfAbsent(this, __ -> {
            LinkedHashMap map = new LinkedHashMap();
            DeserializingMessage.whenBatchCompletes(e -> this.flushUpdates(map));
            return map;
        });
    }

    protected void flushUpdates(Map<Object, Update> map) {
        List<BulkUpdate> updates = map.values().stream().map(update -> update.getValue() == null ? DeleteDocument.builder().id(update.getId()).collection(this.delegate.getCollection()).build() : IndexDocument.fromDocument(update.getDocument())).toList();
        this.delegate.getDocumentStore().bulkUpdate(updates).get();
    }

    @ConstructorProperties(value={"delegate", "documentSerializer"})
    @Generated
    public BatchingHandlerRepository(DefaultHandlerRepository delegate, DocumentSerializer documentSerializer) {
        this.delegate = delegate;
        this.documentSerializer = documentSerializer;
    }

    protected final class Update
    implements Entry<Object> {
        private final String id;
        private final Object value;
        private final AtomicReference<Object> document = new AtomicReference();

        @ConstructorProperties(value={"id", "value"})
        @Generated
        public Update(String id, Object value) {
            this.id = id;
            this.value = value;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Update)) {
                return false;
            }
            Update other = (Update)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            SerializedDocument this$document = this.getDocument();
            SerializedDocument other$document = other.getDocument();
            return !(this$document == null ? other$document != null : !((Object)this$document).equals(other$document));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            SerializedDocument $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BatchingHandlerRepository.Update(id=" + this.getId() + ", value=" + String.valueOf(this.getValue()) + ", document=" + String.valueOf(this.getDocument()) + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public SerializedDocument getDocument() {
            AtomicReference<Object> $value = this.document.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.document;
                synchronized (atomicReference) {
                    $value = this.document.get();
                    if ($value == null) {
                        AtomicReference<Object> actualValue = this.value == null ? null : BatchingHandlerRepository.this.documentSerializer.toDocument(this.value, this.id, BatchingHandlerRepository.this.delegate.getCollection(), BatchingHandlerRepository.this.delegate.getTimestampFunction().apply(this.value), BatchingHandlerRepository.this.delegate.getEndFunction().apply(this.value));
                        $value = actualValue == null ? this.document : actualValue;
                        this.document.set($value);
                    }
                }
            }
            return (SerializedDocument)((Object)($value == this.document ? null : $value));
        }
    }
}

