/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.fluxcapacitor.common.api.HasId;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.search.Facet;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationException;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

@Facet
public abstract class Id<T>
implements HasId {
    @JsonValue
    String functionalId;
    Class<T> type;
    String repositoryId;

    public Id(String functionalId) {
        this(functionalId, "");
    }

    public Id(String functionalId, Class<T> type) {
        this(functionalId, type, "");
    }

    public Id(String functionalId, String prefix) {
        this(functionalId, prefix, true);
    }

    public Id(String functionalId, Class<T> type, String prefix) {
        this(functionalId, type, prefix, true);
    }

    public Id(String functionalId, boolean caseSensitive) {
        this(functionalId, "", caseSensitive);
    }

    public Id(String functionalId, Class<T> type, boolean caseSensitive) {
        this(functionalId, type, "", caseSensitive);
    }

    public Id(@NonNull String functionalId, @NonNull String prefix, boolean caseSensitive) {
        if (functionalId == null) {
            throw new NullPointerException("functionalId is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.functionalId = functionalId;
        this.type = (Class)ReflectionUtils.getFirstTypeArgument(this.getClass().getGenericSuperclass());
        this.repositoryId = caseSensitive ? prefix + this.functionalId : prefix + this.functionalId.toLowerCase();
    }

    public Id(@NonNull String functionalId, @NonNull Class<T> type, @NonNull String prefix, boolean caseSensitive) {
        if (functionalId == null) {
            throw new NullPointerException("functionalId is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (functionalId.isBlank()) {
            throw new ValidationException("Id value should not be blank", Collections.emptySet());
        }
        this.functionalId = functionalId;
        this.type = type;
        this.repositoryId = caseSensitive ? prefix + this.functionalId : prefix + this.functionalId.toLowerCase();
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.functionalId;
    }

    public final String toString() {
        return this.repositoryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id id = (Id)o;
        return this.type.equals(id.type) && this.repositoryId.equals(id.repositoryId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.repositoryId);
    }

    @Generated
    public String getFunctionalId() {
        return this.functionalId;
    }

    @Generated
    public Class<T> getType() {
        return this.type;
    }
}

