/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search.client;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.javaclient.persisting.search.client.InMemorySearchStore;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;

public class CollectionMessageStore
implements MessageStore {
    private final InMemorySearchStore searchClient;
    private final String collection;

    @Override
    public List<SerializedMessage> getBatch(Long minIndex, int maxSize, boolean inclusive) {
        minIndex = minIndex == null ? 0L : minIndex;
        long lastIndex = inclusive ? minIndex - 1L : minIndex;
        return this.searchClient.openStream(this.collection, lastIndex, maxSize).toList();
    }

    @Override
    public Registration registerMonitor(Consumer<List<SerializedMessage>> monitor) {
        return this.searchClient.registerMonitor(this.collection, monitor);
    }

    @Override
    public CompletableFuture<Void> append(List<SerializedMessage> messages) {
        throw new UnsupportedOperationException("Appending of documents is not supported");
    }

    @Override
    public void setRetentionTime(Duration retentionPeriod) {
        this.searchClient.setRetentionTime(retentionPeriod);
    }

    @ConstructorProperties(value={"searchClient", "collection"})
    @Generated
    public CollectionMessageStore(InMemorySearchStore searchClient, String collection) {
        this.searchClient = searchClient;
        this.collection = collection;
    }
}

