/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import java.util.List;
import java.util.function.Consumer;

@FunctionalInterface
public interface BatchInterceptor {
    public static BatchInterceptor noOp() {
        return (c, t) -> c;
    }

    public Consumer<MessageBatch> intercept(Consumer<MessageBatch> var1, Tracker var2);

    default public void shutdown(Tracker tracker) {
    }

    default public BatchInterceptor andThen(final BatchInterceptor nextInterceptor) {
        return new BatchInterceptor(){

            @Override
            public Consumer<MessageBatch> intercept(Consumer<MessageBatch> c, Tracker t) {
                return BatchInterceptor.this.intercept(nextInterceptor.intercept(c, t), t);
            }

            @Override
            public void shutdown(Tracker tracker) {
                nextInterceptor.shutdown(tracker);
                BatchInterceptor.this.shutdown(tracker);
            }
        };
    }

    public static BatchInterceptor join(List<BatchInterceptor> interceptors) {
        return interceptors.stream().reduce(BatchInterceptor::andThen).orElse((c, t) -> c);
    }
}

