/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.Consumer;
import io.fluxcapacitor.javaclient.tracking.ErrorHandler;
import io.fluxcapacitor.javaclient.tracking.FlowRegulator;
import io.fluxcapacitor.javaclient.tracking.LoggingErrorHandler;
import io.fluxcapacitor.javaclient.tracking.NoOpFlowRegulator;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public final class ConsumerConfiguration {
    @NonNull
    private final String name;
    @NonNull
    private final Predicate<Object> handlerFilter;
    @NonNull
    private final ErrorHandler errorHandler;
    private final int threads;
    private final String typeFilter;
    private final int maxFetchSize;
    @NonNull
    private final Duration maxWaitDuration;
    private final List<BatchInterceptor> batchInterceptors;
    private final List<HandlerInterceptor> handlerInterceptors;
    private final boolean filterMessageTarget;
    private final boolean ignoreSegment;
    private final boolean singleTracker;
    private final boolean clientControlledIndex;
    private final Long minIndex;
    private final Long maxIndexExclusive;
    private final boolean exclusive;
    private final boolean passive;
    private final Function<Client, String> trackerIdFactory;
    private final Duration purgeDelay;
    private final FlowRegulator flowRegulator;

    public static Stream<ConsumerConfiguration> configurations(Collection<Class<?>> handlerClasses) {
        return Stream.concat(handlerClasses.stream().flatMap(ConsumerConfiguration::classConfigurations), handlerClasses.stream().map(Class::getPackage).distinct().flatMap(p -> ReflectionUtils.getPackageAndParentPackages(p).stream()).distinct().sorted(Comparator.comparing(Package::getName).reversed()).flatMap(ConsumerConfiguration::packageConfigurations));
    }

    private static Stream<ConsumerConfiguration> classConfigurations(Class<?> type) {
        return Optional.ofNullable((Consumer)ReflectionUtils.getTypeAnnotation(type, Consumer.class)).map(c -> ConsumerConfiguration.getConfiguration(c, h -> HandlerFactory.getTargetClass(h).equals(type))).stream();
    }

    private static Stream<ConsumerConfiguration> packageConfigurations(Package p) {
        return ReflectionUtils.getPackageAnnotation(p, Consumer.class).map(c -> ConsumerConfiguration.getConfiguration(c, h -> {
            Class<?> clazz;
            Class<?> patt0$temp = ReflectionUtils.ifClass(h);
            if (patt0$temp instanceof Class) {
                Class<?> t = patt0$temp;
                clazz = t;
            } else {
                clazz = h.getClass();
            }
            Class<?> type = clazz;
            return type.getPackage().equals(p) || type.getPackage().getName().startsWith(p.getName() + ".");
        })).stream();
    }

    private static ConsumerConfiguration getConfiguration(Consumer consumer, Predicate<Object> handlerFilter) {
        return ConsumerConfiguration.builder().name(consumer.name()).handlerFilter(handlerFilter).errorHandler((ErrorHandler)ReflectionUtils.asInstance(consumer.errorHandler())).flowRegulator((FlowRegulator)ReflectionUtils.asInstance(consumer.flowRegulator())).threads(consumer.threads()).maxFetchSize(consumer.maxFetchSize()).maxWaitDuration(Duration.of(consumer.maxWaitDuration(), consumer.durationUnit())).batchInterceptors(Arrays.stream(consumer.batchInterceptors()).map(ReflectionUtils::asInstance).collect(Collectors.toList())).handlerInterceptors(Arrays.stream(consumer.handlerInterceptors()).map(ReflectionUtils::asInstance).collect(Collectors.toList())).filterMessageTarget(consumer.filterMessageTarget()).ignoreSegment(consumer.ignoreSegment()).clientControlledIndex(consumer.clientControlledIndex()).singleTracker(consumer.singleTracker()).minIndex(consumer.minIndex() < 0L ? null : Long.valueOf(consumer.minIndex())).maxIndexExclusive(consumer.maxIndexExclusive() < 0L ? null : Long.valueOf(consumer.maxIndexExclusive())).exclusive(consumer.exclusive()).passive(consumer.passive()).typeFilter(consumer.typeFilter().isBlank() ? null : consumer.typeFilter()).build();
    }

    @Generated
    private static Predicate<Object> $default$handlerFilter() {
        return o -> true;
    }

    @Generated
    private static ErrorHandler $default$errorHandler() {
        return new LoggingErrorHandler();
    }

    @Generated
    private static int $default$threads() {
        return 1;
    }

    @Generated
    private static String $default$typeFilter() {
        return null;
    }

    @Generated
    private static int $default$maxFetchSize() {
        return 1024;
    }

    @Generated
    private static Duration $default$maxWaitDuration() {
        return Duration.ofSeconds(60L);
    }

    @Generated
    private static boolean $default$filterMessageTarget() {
        return false;
    }

    @Generated
    private static boolean $default$ignoreSegment() {
        return false;
    }

    @Generated
    private static boolean $default$singleTracker() {
        return false;
    }

    @Generated
    private static boolean $default$clientControlledIndex() {
        return false;
    }

    @Generated
    private static Long $default$minIndex() {
        return null;
    }

    @Generated
    private static Long $default$maxIndexExclusive() {
        return null;
    }

    @Generated
    private static boolean $default$exclusive() {
        return true;
    }

    @Generated
    private static boolean $default$passive() {
        return false;
    }

    @Generated
    private static Function<Client, String> $default$trackerIdFactory() {
        return client -> String.format("%s_%s", client.id(), UUID.randomUUID());
    }

    @Generated
    private static Duration $default$purgeDelay() {
        return null;
    }

    @Generated
    private static FlowRegulator $default$flowRegulator() {
        return NoOpFlowRegulator.getInstance();
    }

    @ConstructorProperties(value={"name", "handlerFilter", "errorHandler", "threads", "typeFilter", "maxFetchSize", "maxWaitDuration", "batchInterceptors", "handlerInterceptors", "filterMessageTarget", "ignoreSegment", "singleTracker", "clientControlledIndex", "minIndex", "maxIndexExclusive", "exclusive", "passive", "trackerIdFactory", "purgeDelay", "flowRegulator"})
    @Generated
    ConsumerConfiguration(@NonNull String name, @NonNull Predicate<Object> handlerFilter, @NonNull ErrorHandler errorHandler, int threads, String typeFilter, int maxFetchSize, @NonNull Duration maxWaitDuration, List<BatchInterceptor> batchInterceptors, List<HandlerInterceptor> handlerInterceptors, boolean filterMessageTarget, boolean ignoreSegment, boolean singleTracker, boolean clientControlledIndex, Long minIndex, Long maxIndexExclusive, boolean exclusive, boolean passive, Function<Client, String> trackerIdFactory, Duration purgeDelay, FlowRegulator flowRegulator) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (handlerFilter == null) {
            throw new NullPointerException("handlerFilter is marked non-null but is null");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        if (maxWaitDuration == null) {
            throw new NullPointerException("maxWaitDuration is marked non-null but is null");
        }
        this.name = name;
        this.handlerFilter = handlerFilter;
        this.errorHandler = errorHandler;
        this.threads = threads;
        this.typeFilter = typeFilter;
        this.maxFetchSize = maxFetchSize;
        this.maxWaitDuration = maxWaitDuration;
        this.batchInterceptors = batchInterceptors;
        this.handlerInterceptors = handlerInterceptors;
        this.filterMessageTarget = filterMessageTarget;
        this.ignoreSegment = ignoreSegment;
        this.singleTracker = singleTracker;
        this.clientControlledIndex = clientControlledIndex;
        this.minIndex = minIndex;
        this.maxIndexExclusive = maxIndexExclusive;
        this.exclusive = exclusive;
        this.passive = passive;
        this.trackerIdFactory = trackerIdFactory;
        this.purgeDelay = purgeDelay;
        this.flowRegulator = flowRegulator;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        Builder builder = new Builder().name(this.name).handlerFilter(this.handlerFilter).errorHandler(this.errorHandler).threads(this.threads).typeFilter(this.typeFilter).maxFetchSize(this.maxFetchSize).maxWaitDuration(this.maxWaitDuration).filterMessageTarget(this.filterMessageTarget).ignoreSegment(this.ignoreSegment).singleTracker(this.singleTracker).clientControlledIndex(this.clientControlledIndex).minIndex(this.minIndex).maxIndexExclusive(this.maxIndexExclusive).exclusive(this.exclusive).passive(this.passive).trackerIdFactory(this.trackerIdFactory).purgeDelay(this.purgeDelay).flowRegulator(this.flowRegulator);
        if (this.batchInterceptors != null) {
            builder.batchInterceptors(this.batchInterceptors);
        }
        if (this.handlerInterceptors != null) {
            builder.handlerInterceptors(this.handlerInterceptors);
        }
        return builder;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public Predicate<Object> getHandlerFilter() {
        return this.handlerFilter;
    }

    @NonNull
    @Generated
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Generated
    public int getThreads() {
        return this.threads;
    }

    @Generated
    public String getTypeFilter() {
        return this.typeFilter;
    }

    @Generated
    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    @NonNull
    @Generated
    public Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    @Generated
    public List<BatchInterceptor> getBatchInterceptors() {
        return this.batchInterceptors;
    }

    @Generated
    public List<HandlerInterceptor> getHandlerInterceptors() {
        return this.handlerInterceptors;
    }

    @Generated
    public boolean filterMessageTarget() {
        return this.filterMessageTarget;
    }

    @Generated
    public boolean ignoreSegment() {
        return this.ignoreSegment;
    }

    @Generated
    public boolean singleTracker() {
        return this.singleTracker;
    }

    @Generated
    public boolean clientControlledIndex() {
        return this.clientControlledIndex;
    }

    @Generated
    public Long getMinIndex() {
        return this.minIndex;
    }

    @Generated
    public Long getMaxIndexExclusive() {
        return this.maxIndexExclusive;
    }

    @Generated
    public boolean exclusive() {
        return this.exclusive;
    }

    @Generated
    public boolean passive() {
        return this.passive;
    }

    @Generated
    public Function<Client, String> getTrackerIdFactory() {
        return this.trackerIdFactory;
    }

    @Generated
    public Duration getPurgeDelay() {
        return this.purgeDelay;
    }

    @Generated
    public FlowRegulator getFlowRegulator() {
        return this.flowRegulator;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerConfiguration)) {
            return false;
        }
        ConsumerConfiguration other = (ConsumerConfiguration)o;
        if (this.getThreads() != other.getThreads()) {
            return false;
        }
        if (this.getMaxFetchSize() != other.getMaxFetchSize()) {
            return false;
        }
        if (this.filterMessageTarget() != other.filterMessageTarget()) {
            return false;
        }
        if (this.ignoreSegment() != other.ignoreSegment()) {
            return false;
        }
        if (this.singleTracker() != other.singleTracker()) {
            return false;
        }
        if (this.clientControlledIndex() != other.clientControlledIndex()) {
            return false;
        }
        if (this.exclusive() != other.exclusive()) {
            return false;
        }
        if (this.passive() != other.passive()) {
            return false;
        }
        Long this$minIndex = this.getMinIndex();
        Long other$minIndex = other.getMinIndex();
        if (this$minIndex == null ? other$minIndex != null : !((Object)this$minIndex).equals(other$minIndex)) {
            return false;
        }
        Long this$maxIndexExclusive = this.getMaxIndexExclusive();
        Long other$maxIndexExclusive = other.getMaxIndexExclusive();
        if (this$maxIndexExclusive == null ? other$maxIndexExclusive != null : !((Object)this$maxIndexExclusive).equals(other$maxIndexExclusive)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$typeFilter = this.getTypeFilter();
        String other$typeFilter = other.getTypeFilter();
        if (this$typeFilter == null ? other$typeFilter != null : !this$typeFilter.equals(other$typeFilter)) {
            return false;
        }
        Duration this$maxWaitDuration = this.getMaxWaitDuration();
        Duration other$maxWaitDuration = other.getMaxWaitDuration();
        if (this$maxWaitDuration == null ? other$maxWaitDuration != null : !((Object)this$maxWaitDuration).equals(other$maxWaitDuration)) {
            return false;
        }
        List<BatchInterceptor> this$batchInterceptors = this.getBatchInterceptors();
        List<BatchInterceptor> other$batchInterceptors = other.getBatchInterceptors();
        if (this$batchInterceptors == null ? other$batchInterceptors != null : !((Object)this$batchInterceptors).equals(other$batchInterceptors)) {
            return false;
        }
        List<HandlerInterceptor> this$handlerInterceptors = this.getHandlerInterceptors();
        List<HandlerInterceptor> other$handlerInterceptors = other.getHandlerInterceptors();
        if (this$handlerInterceptors == null ? other$handlerInterceptors != null : !((Object)this$handlerInterceptors).equals(other$handlerInterceptors)) {
            return false;
        }
        Duration this$purgeDelay = this.getPurgeDelay();
        Duration other$purgeDelay = other.getPurgeDelay();
        if (this$purgeDelay == null ? other$purgeDelay != null : !((Object)this$purgeDelay).equals(other$purgeDelay)) {
            return false;
        }
        FlowRegulator this$flowRegulator = this.getFlowRegulator();
        FlowRegulator other$flowRegulator = other.getFlowRegulator();
        return !(this$flowRegulator == null ? other$flowRegulator != null : !this$flowRegulator.equals(other$flowRegulator));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getThreads();
        result = result * 59 + this.getMaxFetchSize();
        result = result * 59 + (this.filterMessageTarget() ? 79 : 97);
        result = result * 59 + (this.ignoreSegment() ? 79 : 97);
        result = result * 59 + (this.singleTracker() ? 79 : 97);
        result = result * 59 + (this.clientControlledIndex() ? 79 : 97);
        result = result * 59 + (this.exclusive() ? 79 : 97);
        result = result * 59 + (this.passive() ? 79 : 97);
        Long $minIndex = this.getMinIndex();
        result = result * 59 + ($minIndex == null ? 43 : ((Object)$minIndex).hashCode());
        Long $maxIndexExclusive = this.getMaxIndexExclusive();
        result = result * 59 + ($maxIndexExclusive == null ? 43 : ((Object)$maxIndexExclusive).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $typeFilter = this.getTypeFilter();
        result = result * 59 + ($typeFilter == null ? 43 : $typeFilter.hashCode());
        Duration $maxWaitDuration = this.getMaxWaitDuration();
        result = result * 59 + ($maxWaitDuration == null ? 43 : ((Object)$maxWaitDuration).hashCode());
        List<BatchInterceptor> $batchInterceptors = this.getBatchInterceptors();
        result = result * 59 + ($batchInterceptors == null ? 43 : ((Object)$batchInterceptors).hashCode());
        List<HandlerInterceptor> $handlerInterceptors = this.getHandlerInterceptors();
        result = result * 59 + ($handlerInterceptors == null ? 43 : ((Object)$handlerInterceptors).hashCode());
        Duration $purgeDelay = this.getPurgeDelay();
        result = result * 59 + ($purgeDelay == null ? 43 : ((Object)$purgeDelay).hashCode());
        FlowRegulator $flowRegulator = this.getFlowRegulator();
        result = result * 59 + ($flowRegulator == null ? 43 : $flowRegulator.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConsumerConfiguration(name=" + this.getName() + ", handlerFilter=" + String.valueOf(this.getHandlerFilter()) + ", errorHandler=" + String.valueOf(this.getErrorHandler()) + ", threads=" + this.getThreads() + ", typeFilter=" + this.getTypeFilter() + ", maxFetchSize=" + this.getMaxFetchSize() + ", maxWaitDuration=" + String.valueOf(this.getMaxWaitDuration()) + ", batchInterceptors=" + String.valueOf(this.getBatchInterceptors()) + ", handlerInterceptors=" + String.valueOf(this.getHandlerInterceptors()) + ", filterMessageTarget=" + this.filterMessageTarget() + ", ignoreSegment=" + this.ignoreSegment() + ", singleTracker=" + this.singleTracker() + ", clientControlledIndex=" + this.clientControlledIndex() + ", minIndex=" + this.getMinIndex() + ", maxIndexExclusive=" + this.getMaxIndexExclusive() + ", exclusive=" + this.exclusive() + ", passive=" + this.passive() + ", trackerIdFactory=" + String.valueOf(this.getTrackerIdFactory()) + ", purgeDelay=" + String.valueOf(this.getPurgeDelay()) + ", flowRegulator=" + String.valueOf(this.getFlowRegulator()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private String name;
        @Generated
        private boolean handlerFilter$set;
        @Generated
        private Predicate<Object> handlerFilter$value;
        @Generated
        private boolean errorHandler$set;
        @Generated
        private ErrorHandler errorHandler$value;
        @Generated
        private boolean threads$set;
        @Generated
        private int threads$value;
        @Generated
        private boolean typeFilter$set;
        @Generated
        private String typeFilter$value;
        @Generated
        private boolean maxFetchSize$set;
        @Generated
        private int maxFetchSize$value;
        @Generated
        private boolean maxWaitDuration$set;
        @Generated
        private Duration maxWaitDuration$value;
        @Generated
        private ArrayList<BatchInterceptor> batchInterceptors;
        @Generated
        private ArrayList<HandlerInterceptor> handlerInterceptors;
        @Generated
        private boolean filterMessageTarget$set;
        @Generated
        private boolean filterMessageTarget$value;
        @Generated
        private boolean ignoreSegment$set;
        @Generated
        private boolean ignoreSegment$value;
        @Generated
        private boolean singleTracker$set;
        @Generated
        private boolean singleTracker$value;
        @Generated
        private boolean clientControlledIndex$set;
        @Generated
        private boolean clientControlledIndex$value;
        @Generated
        private boolean minIndex$set;
        @Generated
        private Long minIndex$value;
        @Generated
        private boolean maxIndexExclusive$set;
        @Generated
        private Long maxIndexExclusive$value;
        @Generated
        private boolean exclusive$set;
        @Generated
        private boolean exclusive$value;
        @Generated
        private boolean passive$set;
        @Generated
        private boolean passive$value;
        @Generated
        private boolean trackerIdFactory$set;
        @Generated
        private Function<Client, String> trackerIdFactory$value;
        @Generated
        private boolean purgeDelay$set;
        @Generated
        private Duration purgeDelay$value;
        @Generated
        private boolean flowRegulator$set;
        @Generated
        private FlowRegulator flowRegulator$value;

        @Generated
        Builder() {
        }

        @Generated
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public Builder handlerFilter(@NonNull Predicate<Object> handlerFilter) {
            if (handlerFilter == null) {
                throw new NullPointerException("handlerFilter is marked non-null but is null");
            }
            this.handlerFilter$value = handlerFilter;
            this.handlerFilter$set = true;
            return this;
        }

        @Generated
        public Builder errorHandler(@NonNull ErrorHandler errorHandler) {
            if (errorHandler == null) {
                throw new NullPointerException("errorHandler is marked non-null but is null");
            }
            this.errorHandler$value = errorHandler;
            this.errorHandler$set = true;
            return this;
        }

        @Generated
        public Builder threads(int threads) {
            this.threads$value = threads;
            this.threads$set = true;
            return this;
        }

        @Generated
        public Builder typeFilter(String typeFilter) {
            this.typeFilter$value = typeFilter;
            this.typeFilter$set = true;
            return this;
        }

        @Generated
        public Builder maxFetchSize(int maxFetchSize) {
            this.maxFetchSize$value = maxFetchSize;
            this.maxFetchSize$set = true;
            return this;
        }

        @Generated
        public Builder maxWaitDuration(@NonNull Duration maxWaitDuration) {
            if (maxWaitDuration == null) {
                throw new NullPointerException("maxWaitDuration is marked non-null but is null");
            }
            this.maxWaitDuration$value = maxWaitDuration;
            this.maxWaitDuration$set = true;
            return this;
        }

        @Generated
        public Builder batchInterceptor(BatchInterceptor batchInterceptor) {
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.add(batchInterceptor);
            return this;
        }

        @Generated
        public Builder batchInterceptors(Collection<? extends BatchInterceptor> batchInterceptors) {
            if (batchInterceptors == null) {
                throw new NullPointerException("batchInterceptors cannot be null");
            }
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.addAll(batchInterceptors);
            return this;
        }

        @Generated
        public Builder clearBatchInterceptors() {
            if (this.batchInterceptors != null) {
                this.batchInterceptors.clear();
            }
            return this;
        }

        @Generated
        public Builder handlerInterceptor(HandlerInterceptor handlerInterceptor) {
            if (this.handlerInterceptors == null) {
                this.handlerInterceptors = new ArrayList();
            }
            this.handlerInterceptors.add(handlerInterceptor);
            return this;
        }

        @Generated
        public Builder handlerInterceptors(Collection<? extends HandlerInterceptor> handlerInterceptors) {
            if (handlerInterceptors == null) {
                throw new NullPointerException("handlerInterceptors cannot be null");
            }
            if (this.handlerInterceptors == null) {
                this.handlerInterceptors = new ArrayList();
            }
            this.handlerInterceptors.addAll(handlerInterceptors);
            return this;
        }

        @Generated
        public Builder clearHandlerInterceptors() {
            if (this.handlerInterceptors != null) {
                this.handlerInterceptors.clear();
            }
            return this;
        }

        @Generated
        public Builder filterMessageTarget(boolean filterMessageTarget) {
            this.filterMessageTarget$value = filterMessageTarget;
            this.filterMessageTarget$set = true;
            return this;
        }

        @Generated
        public Builder ignoreSegment(boolean ignoreSegment) {
            this.ignoreSegment$value = ignoreSegment;
            this.ignoreSegment$set = true;
            return this;
        }

        @Generated
        public Builder singleTracker(boolean singleTracker) {
            this.singleTracker$value = singleTracker;
            this.singleTracker$set = true;
            return this;
        }

        @Generated
        public Builder clientControlledIndex(boolean clientControlledIndex) {
            this.clientControlledIndex$value = clientControlledIndex;
            this.clientControlledIndex$set = true;
            return this;
        }

        @Generated
        public Builder minIndex(Long minIndex) {
            this.minIndex$value = minIndex;
            this.minIndex$set = true;
            return this;
        }

        @Generated
        public Builder maxIndexExclusive(Long maxIndexExclusive) {
            this.maxIndexExclusive$value = maxIndexExclusive;
            this.maxIndexExclusive$set = true;
            return this;
        }

        @Generated
        public Builder exclusive(boolean exclusive) {
            this.exclusive$value = exclusive;
            this.exclusive$set = true;
            return this;
        }

        @Generated
        public Builder passive(boolean passive) {
            this.passive$value = passive;
            this.passive$set = true;
            return this;
        }

        @Generated
        public Builder trackerIdFactory(Function<Client, String> trackerIdFactory) {
            this.trackerIdFactory$value = trackerIdFactory;
            this.trackerIdFactory$set = true;
            return this;
        }

        @Generated
        public Builder purgeDelay(Duration purgeDelay) {
            this.purgeDelay$value = purgeDelay;
            this.purgeDelay$set = true;
            return this;
        }

        @Generated
        public Builder flowRegulator(FlowRegulator flowRegulator) {
            this.flowRegulator$value = flowRegulator;
            this.flowRegulator$set = true;
            return this;
        }

        @Generated
        public ConsumerConfiguration build() {
            List<BatchInterceptor> batchInterceptors = switch (this.batchInterceptors == null ? 0 : this.batchInterceptors.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.batchInterceptors.get(0));
                default -> Collections.unmodifiableList(new ArrayList<BatchInterceptor>(this.batchInterceptors));
            };
            List<HandlerInterceptor> handlerInterceptors = switch (this.handlerInterceptors == null ? 0 : this.handlerInterceptors.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.handlerInterceptors.get(0));
                default -> Collections.unmodifiableList(new ArrayList<HandlerInterceptor>(this.handlerInterceptors));
            };
            Predicate<Object> handlerFilter$value = this.handlerFilter$value;
            if (!this.handlerFilter$set) {
                handlerFilter$value = ConsumerConfiguration.$default$handlerFilter();
            }
            ErrorHandler errorHandler$value = this.errorHandler$value;
            if (!this.errorHandler$set) {
                errorHandler$value = ConsumerConfiguration.$default$errorHandler();
            }
            int threads$value = this.threads$value;
            if (!this.threads$set) {
                threads$value = ConsumerConfiguration.$default$threads();
            }
            String typeFilter$value = this.typeFilter$value;
            if (!this.typeFilter$set) {
                typeFilter$value = ConsumerConfiguration.$default$typeFilter();
            }
            int maxFetchSize$value = this.maxFetchSize$value;
            if (!this.maxFetchSize$set) {
                maxFetchSize$value = ConsumerConfiguration.$default$maxFetchSize();
            }
            Duration maxWaitDuration$value = this.maxWaitDuration$value;
            if (!this.maxWaitDuration$set) {
                maxWaitDuration$value = ConsumerConfiguration.$default$maxWaitDuration();
            }
            boolean filterMessageTarget$value = this.filterMessageTarget$value;
            if (!this.filterMessageTarget$set) {
                filterMessageTarget$value = ConsumerConfiguration.$default$filterMessageTarget();
            }
            boolean ignoreSegment$value = this.ignoreSegment$value;
            if (!this.ignoreSegment$set) {
                ignoreSegment$value = ConsumerConfiguration.$default$ignoreSegment();
            }
            boolean singleTracker$value = this.singleTracker$value;
            if (!this.singleTracker$set) {
                singleTracker$value = ConsumerConfiguration.$default$singleTracker();
            }
            boolean clientControlledIndex$value = this.clientControlledIndex$value;
            if (!this.clientControlledIndex$set) {
                clientControlledIndex$value = ConsumerConfiguration.$default$clientControlledIndex();
            }
            Long minIndex$value = this.minIndex$value;
            if (!this.minIndex$set) {
                minIndex$value = ConsumerConfiguration.$default$minIndex();
            }
            Long maxIndexExclusive$value = this.maxIndexExclusive$value;
            if (!this.maxIndexExclusive$set) {
                maxIndexExclusive$value = ConsumerConfiguration.$default$maxIndexExclusive();
            }
            boolean exclusive$value = this.exclusive$value;
            if (!this.exclusive$set) {
                exclusive$value = ConsumerConfiguration.$default$exclusive();
            }
            boolean passive$value = this.passive$value;
            if (!this.passive$set) {
                passive$value = ConsumerConfiguration.$default$passive();
            }
            Function<Client, String> trackerIdFactory$value = this.trackerIdFactory$value;
            if (!this.trackerIdFactory$set) {
                trackerIdFactory$value = ConsumerConfiguration.$default$trackerIdFactory();
            }
            Duration purgeDelay$value = this.purgeDelay$value;
            if (!this.purgeDelay$set) {
                purgeDelay$value = ConsumerConfiguration.$default$purgeDelay();
            }
            FlowRegulator flowRegulator$value = this.flowRegulator$value;
            if (!this.flowRegulator$set) {
                flowRegulator$value = ConsumerConfiguration.$default$flowRegulator();
            }
            return new ConsumerConfiguration(this.name, handlerFilter$value, errorHandler$value, threads$value, typeFilter$value, maxFetchSize$value, maxWaitDuration$value, batchInterceptors, handlerInterceptors, filterMessageTarget$value, ignoreSegment$value, singleTracker$value, clientControlledIndex$value, minIndex$value, maxIndexExclusive$value, exclusive$value, passive$value, trackerIdFactory$value, purgeDelay$value, flowRegulator$value);
        }

        @Generated
        public String toString() {
            return "ConsumerConfiguration.Builder(name=" + this.name + ", handlerFilter$value=" + String.valueOf(this.handlerFilter$value) + ", errorHandler$value=" + String.valueOf(this.errorHandler$value) + ", threads$value=" + this.threads$value + ", typeFilter$value=" + this.typeFilter$value + ", maxFetchSize$value=" + this.maxFetchSize$value + ", maxWaitDuration$value=" + String.valueOf(this.maxWaitDuration$value) + ", batchInterceptors=" + String.valueOf(this.batchInterceptors) + ", handlerInterceptors=" + String.valueOf(this.handlerInterceptors) + ", filterMessageTarget$value=" + this.filterMessageTarget$value + ", ignoreSegment$value=" + this.ignoreSegment$value + ", singleTracker$value=" + this.singleTracker$value + ", clientControlledIndex$value=" + this.clientControlledIndex$value + ", minIndex$value=" + this.minIndex$value + ", maxIndexExclusive$value=" + this.maxIndexExclusive$value + ", exclusive$value=" + this.exclusive$value + ", passive$value=" + this.passive$value + ", trackerIdFactory$value=" + String.valueOf(this.trackerIdFactory$value) + ", purgeDelay$value=" + String.valueOf(this.purgeDelay$value) + ", flowRegulator$value=" + String.valueOf(this.flowRegulator$value) + ")";
        }
    }
}

