/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StallingBatchInterceptor
implements BatchInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StallingBatchInterceptor.class);
    private final int desiredBatchSize;
    @NonNull
    private final Duration maximumStallingDuration;
    @NonNull
    private final Duration retryFrequency;
    private final AtomicReference<Instant> firstRefusal = new AtomicReference();

    @Override
    public Consumer<MessageBatch> intercept(Consumer<MessageBatch> consumer, Tracker tracker) {
        return b -> {
            if (b.getSize() >= this.desiredBatchSize || this.hasPassedDeadline()) {
                consumer.accept((MessageBatch)b);
                this.firstRefusal.set(null);
            } else {
                this.stall();
            }
        };
    }

    protected boolean hasPassedDeadline() {
        return Optional.ofNullable(this.firstRefusal.get()).filter(f -> !FluxCapacitor.currentTime().isBefore(f.plus(this.maximumStallingDuration))).isPresent();
    }

    protected void stall() {
        this.firstRefusal.updateAndGet(f -> f == null ? FluxCapacitor.currentTime() : f);
        try {
            Thread.sleep(this.retryFrequency.toMillis());
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    @Generated
    private static int $default$desiredBatchSize() {
        return 512;
    }

    @Generated
    private static Duration $default$maximumStallingDuration() {
        return Duration.ofSeconds(60L);
    }

    @Generated
    private static Duration $default$retryFrequency() {
        return Duration.ofSeconds(1L);
    }

    @Generated
    public static StallingBatchInterceptorBuilder builder() {
        return new StallingBatchInterceptorBuilder();
    }

    @Generated
    public StallingBatchInterceptor() {
        this.desiredBatchSize = StallingBatchInterceptor.$default$desiredBatchSize();
        this.maximumStallingDuration = StallingBatchInterceptor.$default$maximumStallingDuration();
        this.retryFrequency = StallingBatchInterceptor.$default$retryFrequency();
    }

    @ConstructorProperties(value={"desiredBatchSize", "maximumStallingDuration", "retryFrequency"})
    @Generated
    public StallingBatchInterceptor(int desiredBatchSize, @NonNull Duration maximumStallingDuration, @NonNull Duration retryFrequency) {
        if (maximumStallingDuration == null) {
            throw new NullPointerException("maximumStallingDuration is marked non-null but is null");
        }
        if (retryFrequency == null) {
            throw new NullPointerException("retryFrequency is marked non-null but is null");
        }
        this.desiredBatchSize = desiredBatchSize;
        this.maximumStallingDuration = maximumStallingDuration;
        this.retryFrequency = retryFrequency;
    }

    @Generated
    public static class StallingBatchInterceptorBuilder {
        @Generated
        private boolean desiredBatchSize$set;
        @Generated
        private int desiredBatchSize$value;
        @Generated
        private boolean maximumStallingDuration$set;
        @Generated
        private Duration maximumStallingDuration$value;
        @Generated
        private boolean retryFrequency$set;
        @Generated
        private Duration retryFrequency$value;

        @Generated
        StallingBatchInterceptorBuilder() {
        }

        @Generated
        public StallingBatchInterceptorBuilder desiredBatchSize(int desiredBatchSize) {
            this.desiredBatchSize$value = desiredBatchSize;
            this.desiredBatchSize$set = true;
            return this;
        }

        @Generated
        public StallingBatchInterceptorBuilder maximumStallingDuration(@NonNull Duration maximumStallingDuration) {
            if (maximumStallingDuration == null) {
                throw new NullPointerException("maximumStallingDuration is marked non-null but is null");
            }
            this.maximumStallingDuration$value = maximumStallingDuration;
            this.maximumStallingDuration$set = true;
            return this;
        }

        @Generated
        public StallingBatchInterceptorBuilder retryFrequency(@NonNull Duration retryFrequency) {
            if (retryFrequency == null) {
                throw new NullPointerException("retryFrequency is marked non-null but is null");
            }
            this.retryFrequency$value = retryFrequency;
            this.retryFrequency$set = true;
            return this;
        }

        @Generated
        public StallingBatchInterceptor build() {
            int desiredBatchSize$value = this.desiredBatchSize$value;
            if (!this.desiredBatchSize$set) {
                desiredBatchSize$value = StallingBatchInterceptor.$default$desiredBatchSize();
            }
            Duration maximumStallingDuration$value = this.maximumStallingDuration$value;
            if (!this.maximumStallingDuration$set) {
                maximumStallingDuration$value = StallingBatchInterceptor.$default$maximumStallingDuration();
            }
            Duration retryFrequency$value = this.retryFrequency$value;
            if (!this.retryFrequency$set) {
                retryFrequency$value = StallingBatchInterceptor.$default$retryFrequency();
            }
            return new StallingBatchInterceptor(desiredBatchSize$value, maximumStallingDuration$value, retryFrequency$value);
        }

        @Generated
        public String toString() {
            return "StallingBatchInterceptor.StallingBatchInterceptorBuilder(desiredBatchSize$value=" + this.desiredBatchSize$value + ", maximumStallingDuration$value=" + String.valueOf(this.maximumStallingDuration$value) + ", retryFrequency$value=" + String.valueOf(this.retryFrequency$value) + ")";
        }
    }
}

