/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import com.google.auto.service.AutoService;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import io.fluxcapacitor.javaclient.tracking.handling.HandleQuery;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.fluxcapacitor.javaclient.tracking.handling.HandleQuery", "io.fluxcapacitor.javaclient.tracking.handling.HandleCommand"})
@AutoService(value={Processor.class})
public class RequestAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeMirror requestType = this.getTypeUtils().erasure(this.getElementUtils().getTypeElement("io.fluxcapacitor.javaclient.tracking.handling.Request").asType());
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.validateMethod(element, requestType);
            }
        }
        return false;
    }

    protected void validateMethod(Element method, TypeMirror requestType) {
        if (this.isPassive(method)) {
            return;
        }
        TypeMirror classType = method.getEnclosingElement().asType();
        if (this.getTypeUtils().isAssignable(classType, requestType)) {
            this.validateReturnType(method, classType, requestType);
        } else {
            for (TypeMirror typeMirror : ((ExecutableType)method.asType()).getParameterTypes()) {
                this.validateReturnType(method, typeMirror, requestType);
            }
        }
    }

    protected void validateReturnType(Element method, TypeMirror payloadType, TypeMirror requestType) {
        if (!this.getTypeUtils().isAssignable(payloadType, requestType)) {
            return;
        }
        ExecutableType methodType = (ExecutableType)method.asType();
        for (TypeMirror typeMirror : ((TypeElement)((DeclaredType)payloadType).asElement()).getInterfaces()) {
            List<? extends TypeMirror> typeArguments;
            if (!this.getTypeUtils().isAssignable(payloadType, requestType) || (typeArguments = ((DeclaredType)typeMirror).getTypeArguments()).isEmpty()) continue;
            TypeMirror futureTypeElement = this.processingEnv.getElementUtils().getTypeElement(Future.class.getCanonicalName()).asType();
            TypeMirror expectedReturnType = typeArguments.getFirst();
            TypeMirror handlerReturnType = methodType.getReturnType();
            if (this.getTypeUtils().isAssignable(this.getTypeUtils().erasure(handlerReturnType), this.getTypeUtils().erasure(futureTypeElement))) {
                List<? extends TypeMirror> futureTypeArgs = ((DeclaredType)handlerReturnType).getTypeArguments();
                if (futureTypeArgs.isEmpty()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Return type of request handler is invalid. Should be assignable to Future<%s>".formatted(expectedReturnType), method);
                    return;
                }
                handlerReturnType = futureTypeArgs.getFirst();
            }
            if (this.getTypeUtils().isAssignable(handlerReturnType, expectedReturnType)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Return type of request handler is invalid. Should be " + String.valueOf(expectedReturnType), method);
            return;
        }
    }

    private boolean isPassive(Element method) {
        if (Optional.ofNullable(method.getAnnotation(HandleCommand.class)).map(HandleCommand::passive).orElse(false).booleanValue()) {
            return true;
        }
        return Optional.ofNullable(method.getAnnotation(HandleQuery.class)).map(HandleQuery::passive).orElse(false) != false;
    }

    private Types getTypeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    private Elements getElementUtils() {
        return this.processingEnv.getElementUtils();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

