/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.web.DefaultWebRequestContext;
import io.fluxcapacitor.javaclient.web.Path;
import io.fluxcapacitor.javaclient.web.WebPattern;
import io.fluxcapacitor.javaclient.web.WebUtils;
import io.jooby.Router;
import io.jooby.internal.RouterImpl;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class WebHandlerMatcher
implements HandlerMatcher<Object, DeserializingMessage> {
    private final Router router = new RouterImpl();

    public static WebHandlerMatcher create(Class<?> c, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, HandlerConfiguration<DeserializingMessage> config) {
        List<HandlerInspector.MethodHandlerMatcher<DeserializingMessage>> matchers = Stream.concat(ReflectionUtils.getAllMethods(c).stream(), Arrays.stream(c.getDeclaredConstructors())).filter(m -> config.methodMatches(c, (Executable)m)).flatMap(m -> Stream.of(new HandlerInspector.MethodHandlerMatcher((Executable)m, c, parameterResolvers, config))).toList();
        return new WebHandlerMatcher(matchers);
    }

    protected WebHandlerMatcher(List<HandlerInspector.MethodHandlerMatcher<DeserializingMessage>> methodHandlerMatchers) {
        HashMap<String, Router> subRouters = new HashMap<String, Router>();
        for (HandlerInspector.MethodHandlerMatcher<DeserializingMessage> m : methodHandlerMatchers) {
            String root = ReflectionUtils.getMethodAnnotation(m.getExecutable(), Path.class).or(() -> Optional.ofNullable((Path)ReflectionUtils.getTypeAnnotation(m.getTargetClass(), Path.class))).or(() -> ReflectionUtils.getPackageAnnotation(m.getTargetClass().getPackage(), Path.class)).map(Path::value).map(p -> p.endsWith("//") || !p.endsWith("/") ? p : p.substring(0, p.length() - 1)).orElse("");
            List<WebPattern> webPatterns = WebUtils.getWebPatterns(m.getExecutable());
            for (WebPattern pattern : webPatterns) {
                String origin2 = pattern.getOrigin();
                Router router = origin2 == null ? this.router : subRouters.computeIfAbsent(origin2, __ -> new RouterImpl());
                router.route(pattern.getMethod().name(), root + pattern.getPath(), ctx -> m);
            }
        }
        subRouters.forEach((origin, subRouter) -> this.router.mount(ctx -> {
            if (ctx instanceof DefaultWebRequestContext) {
                DefaultWebRequestContext context = (DefaultWebRequestContext)ctx;
                return Objects.equals(origin, context.getOrigin());
            }
            throw new UnsupportedOperationException("Unknown context class: " + String.valueOf(ctx.getClass()));
        }, (Router)subRouter));
    }

    @Override
    public boolean canHandle(DeserializingMessage message) {
        return this.methodMatcher(message).map(m -> m.canHandle(message)).orElse(false);
    }

    @Override
    public Stream<Executable> matchingMethods(DeserializingMessage message) {
        return this.methodMatcher(message).stream().flatMap(m -> m.matchingMethods(message));
    }

    @Override
    public Optional<HandlerInvoker> getInvoker(Object target, DeserializingMessage message) {
        return this.methodMatcher(message).flatMap(m -> m.getInvoker(target, message));
    }

    protected Optional<HandlerInspector.MethodHandlerMatcher<DeserializingMessage>> methodMatcher(DeserializingMessage message) {
        if (message.getMessageType() != MessageType.WEBREQUEST) {
            return Optional.empty();
        }
        DefaultWebRequestContext context = DefaultWebRequestContext.getWebRequestContext(message);
        return Optional.of(this.router.match(context)).filter(Router.Match::matches).map(match -> (HandlerInspector.MethodHandlerMatcher)match.execute(context));
    }
}

