/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import io.fluxcapacitor.javaclient.web.WebPattern;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.stream.Stream;
import lombok.Generated;

public final class WebParameters {
    private final String[] value;
    private final HttpRequestMethod[] method;
    private final boolean disabled;

    public Stream<WebPattern> getWebPatterns() {
        Stream<HttpRequestMethod> methodStream = this.method.length == 0 ? Arrays.stream(HttpRequestMethod.values()) : Arrays.stream(this.method);
        return methodStream.flatMap(method -> switch (this.value.length) {
            case 0 -> Stream.of(new WebPattern("", (HttpRequestMethod)((Object)method)));
            case 1 -> Stream.of(new WebPattern(this.value[0], (HttpRequestMethod)((Object)method)));
            default -> Arrays.stream(this.value).map(v -> new WebPattern((String)v, (HttpRequestMethod)((Object)method)));
        });
    }

    @ConstructorProperties(value={"value", "method", "disabled"})
    @Generated
    public WebParameters(String[] value, HttpRequestMethod[] method, boolean disabled) {
        this.value = value;
        this.method = method;
        this.disabled = disabled;
    }

    @Generated
    public String[] getValue() {
        return this.value;
    }

    @Generated
    public HttpRequestMethod[] getMethod() {
        return this.method;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebParameters)) {
            return false;
        }
        WebParameters other = (WebParameters)o;
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getValue(), other.getValue())) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getMethod(), (Object[])other.getMethod());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getValue());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getMethod());
        return result;
    }

    @Generated
    public String toString() {
        return "WebParameters(value=" + Arrays.deepToString(this.getValue()) + ", method=" + Arrays.deepToString((Object[])this.getMethod()) + ", disabled=" + this.isDisabled() + ")";
    }
}

