/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.serialization.JsonUtils;
import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import io.fluxcapacitor.common.serialization.compression.CompressionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.web.WebUtils;
import java.beans.ConstructorProperties;
import java.net.HttpCookie;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class WebResponse
extends Message {
    private static final List<String> gzipEncoding = List.of("gzip");
    @NonNull
    private final Map<String, List<String>> headers;
    private final Integer status;
    private final AtomicReference<Object> decodedPayload = new AtomicReference();

    private WebResponse(Builder builder) {
        super(builder.payload(), Metadata.of("status", builder.status(), "headers", builder.headers()));
        this.status = builder.status();
        this.headers = builder.headers();
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp"})
    WebResponse(Object payload, Metadata metadata, String messageId, Instant timestamp) {
        super(payload, metadata, messageId, timestamp);
        this.headers = Optional.ofNullable(metadata.get((Object)"headers", Map.class)).map(map -> WebUtils.asHeaderMap(map)).orElseGet(WebUtils::emptyHeaderMap);
        this.status = Optional.ofNullable(metadata.get("status")).map(Integer::valueOf).orElse(null);
    }

    public WebResponse(Message m) {
        this(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp());
    }

    @Override
    public SerializedMessage serialize(Serializer serializer) {
        return this.headers.getOrDefault("Content-Type", List.of()).stream().findFirst().map(format -> new SerializedMessage(serializer.serialize(this.getEncodedPayload(), (String)format), this.getMetadata(), this.getMessageId(), this.getTimestamp().toEpochMilli())).orElseGet(() -> super.serialize(serializer));
    }

    public static Metadata asMetadata(int statusCode, Map<String, List<String>> headers) {
        return Metadata.of("status", statusCode, "headers", headers);
    }

    @Override
    public WebResponse withMetadata(Metadata metadata) {
        return new WebResponse(super.withMetadata(metadata));
    }

    @Override
    public WebResponse addMetadata(Metadata metadata) {
        return (WebResponse)super.addMetadata(metadata);
    }

    @Override
    public WebResponse addMetadata(String key, Object value) {
        return (WebResponse)super.addMetadata(key, value);
    }

    @Override
    public WebResponse addMetadata(Object ... keyValues) {
        return (WebResponse)super.addMetadata(keyValues);
    }

    @Override
    public WebResponse addMetadata(Map<String, ?> values2) {
        return (WebResponse)super.addMetadata(values2);
    }

    @Override
    public WebResponse addUser(User user) {
        return (WebResponse)super.addUser(user);
    }

    @Override
    public WebResponse withPayload(Object payload) {
        if (payload == this.getPayload()) {
            return this;
        }
        return this.toBuilder().payload(payload).build();
    }

    @Override
    public WebResponse withMessageId(String messageId) {
        return new WebResponse(super.withMessageId(messageId));
    }

    @Override
    public WebResponse withTimestamp(Instant timestamp) {
        return new WebResponse(super.withTimestamp(timestamp));
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Map<String, List<String>> getHeaders(Metadata metadata) {
        return Optional.ofNullable(metadata.get((Object)"headers", Map.class)).orElse(Collections.emptyMap());
    }

    public static Integer getStatusCode(Metadata metadata) {
        return Optional.ofNullable(metadata.get("status")).map(Integer::valueOf).orElse(null);
    }

    @Override
    public <R> R getPayload() {
        return (R)this.getDecodedPayload();
    }

    @Override
    public <R> R getPayloadAs(Class<R> type) {
        return "application/json".equalsIgnoreCase(this.getContentType()) ? JsonUtils.convertValue(this.getPayload(), type) : super.getPayloadAs(type);
    }

    public List<String> getHeaders(String name) {
        return this.headers.getOrDefault(name, Collections.emptyList());
    }

    public WebResponse retainHeaders(String ... headerNames) {
        Map<String, List<String>> filtered = WebUtils.asHeaderMap(this.headers);
        filtered.keySet().retainAll(Arrays.asList(headerNames));
        return this.toBuilder().clearHeaders().headers(filtered).build();
    }

    public String getHeader(String name) {
        return this.getHeaders(name).stream().findFirst().orElse(null);
    }

    public List<HttpCookie> getCookies() {
        return WebUtils.parseResponseCookieHeader(this.getHeaders("Set-Cookie"));
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    Object getEncodedPayload() {
        return super.getPayload();
    }

    Object decodePayload() {
        Object result = this.getEncodedPayload();
        if (result instanceof byte[]) {
            byte[] bytes = (byte[])result;
            if (Objects.equals(this.getHeaders("Content-Encoding"), gzipEncoding)) {
                return CompressionUtils.decompress(bytes, CompressionAlgorithm.GZIP);
            }
        }
        return result;
    }

    @NonNull
    @Generated
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebResponse)) {
            return false;
        }
        WebResponse other = (WebResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Object this$decodedPayload = this.getDecodedPayload();
        Object other$decodedPayload = other.getDecodedPayload();
        return !(this$decodedPayload == null ? other$decodedPayload != null : !this$decodedPayload.equals(other$decodedPayload));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Object $decodedPayload = this.getDecodedPayload();
        result = result * 59 + ($decodedPayload == null ? 43 : $decodedPayload.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WebResponse(super=" + super.toString() + ", headers=" + String.valueOf(this.getHeaders()) + ", status=" + this.getStatus() + ", decodedPayload=" + String.valueOf(this.getDecodedPayload()) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private Object getDecodedPayload() {
        AtomicReference<Object> $value = this.decodedPayload.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.decodedPayload;
            synchronized (atomicReference) {
                $value = this.decodedPayload.get();
                if ($value == null) {
                    AtomicReference<Object> actualValue = this.decodePayload();
                    $value = actualValue == null ? this.decodedPayload : actualValue;
                    this.decodedPayload.set($value);
                }
            }
        }
        return $value == this.decodedPayload ? null : $value;
    }

    public static class Builder {
        private final Map<String, List<String>> headers = WebUtils.emptyHeaderMap();
        private List<HttpCookie> cookies = new ArrayList<HttpCookie>();
        private Object payload;
        private Integer status;

        protected Builder(WebResponse response) {
            this.payload(response.getEncodedPayload());
            this.status(response.getStatus());
            this.headers(response.getHeaders());
            this.cookies.addAll(WebUtils.parseResponseCookieHeader(this.headers.remove("Set-Cookie")));
        }

        public Builder payload(Object payload) {
            this.payload = payload;
            if (!this.headers().containsKey("Content-Type")) {
                if (payload instanceof String) {
                    return this.contentType("text/plain");
                }
                if (payload instanceof byte[]) {
                    return this.contentType("application/octet-stream");
                }
            }
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder header(String key, Collection<String> values2) {
            this.headers.computeIfAbsent(key, k -> new ArrayList()).addAll(values2);
            return this;
        }

        public Builder header(String key, String value) {
            return this.header(key, List.of(value));
        }

        public Builder clearHeader(String key) {
            this.headers.computeIfPresent(key, (k, v) -> null);
            return this;
        }

        public Builder clearHeaders() {
            this.headers.clear();
            return this;
        }

        public Builder cookie(HttpCookie cookie) {
            this.cookies.add(cookie);
            return this;
        }

        public Builder contentType(String contentType) {
            return this.header("Content-Type", contentType);
        }

        public Map<String, List<String>> headers() {
            if (!this.cookies.isEmpty()) {
                this.clearHeader("Set-Cookie").header("Set-Cookie", this.cookies.stream().map(WebUtils::toResponseHeaderString).collect(Collectors.toList()));
            }
            return this.headers;
        }

        public Integer status() {
            return this.status == null ? (this.payload == null ? 204 : 200) : this.status;
        }

        public WebResponse build() {
            return new WebResponse(this);
        }

        @Generated
        public List<HttpCookie> cookies() {
            return this.cookies;
        }

        @Generated
        public Object payload() {
            return this.payload;
        }

        @Generated
        public Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.status();
            Integer other$status = other.status();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.headers();
            Map<String, List<String>> other$headers = other.headers();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            List<HttpCookie> this$cookies = this.cookies();
            List<HttpCookie> other$cookies = other.cookies();
            if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
                return false;
            }
            Object this$payload = this.payload();
            Object other$payload = other.payload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.status();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            Map<String, List<String>> $headers = this.headers();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            List<HttpCookie> $cookies = this.cookies();
            result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
            Object $payload = this.payload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebResponse.Builder(headers=" + String.valueOf(this.headers()) + ", cookies=" + String.valueOf(this.cookies()) + ", payload=" + String.valueOf(this.payload()) + ", status=" + this.status() + ")";
        }

        @Generated
        public Builder() {
        }
    }
}

