/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.proxy;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.configuration.ApplicationProperties;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.proxy.ForwardProxyConsumer;
import io.fluxcapacitor.proxy.ProxyRequestHandler;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.util.Headers;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyServer.class);

    public static void main(String[] args2) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> log.error("Uncaught error", e));
        int port = ApplicationProperties.getIntegerProperty("PROXY_PORT", 80);
        Client client = Optional.ofNullable(ApplicationProperties.getProperty("FLUX_URL")).map(url -> WebSocketClient.newInstance(WebSocketClient.ClientConfig.builder().name("$proxy").serviceBaseUrl((String)url).projectId(ApplicationProperties.getProperty("PROJECT_ID")).build())).orElseThrow(() -> new IllegalStateException("FLUX_URL environment variable is not set"));
        Registration registration = ProxyServer.start(port, new ProxyRequestHandler(client)).merge(ForwardProxyConsumer.start(client));
        log.info("Flux Capacitor proxy server running on port {}", (Object)port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Stopping Flux Capacitor proxy server");
            registration.cancel();
        }, ObjectUtils.newThreadName("ProxyServer-shutdown")));
    }

    public static Registration start(int port, ProxyRequestHandler proxyHandler) {
        Undertow server = Undertow.builder().addHttpListener(port, "0.0.0.0").setHandler(Handlers.path().addPrefixPath("/", proxyHandler).addExactPath(ApplicationProperties.getProperty("PROXY_HEALTH_ENDPOINT", "/proxy/health"), exchange -> {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
            exchange.getResponseSender().send("Healthy");
        })).build();
        server.start();
        return () -> {
            proxyHandler.close();
            server.stop();
        };
    }
}

