/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Route;
import io.jooby.SneakyThrows;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class CompletionListeners {
    private List<Route.Complete> listeners;

    public void addListener(@NonNull Route.Complete listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Route.Complete>();
        }
        this.listeners.add(listener);
    }

    public void run(@NonNull Context ctx) {
        if (this.listeners != null) {
            Throwable cause = null;
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                try {
                    this.listeners.get(i).apply(ctx);
                    continue;
                }
                catch (Throwable x) {
                    if (cause == null) {
                        cause = x;
                        continue;
                    }
                    cause.addSuppressed(x);
                }
            }
            if (cause != null) {
                ctx.getRouter().getLog().error("Completion listener(s) resulted in exception(s): {} {}", ctx.getMethod(), ctx.getRequestPath(), cause);
                Stream.concat(Stream.of(cause), Stream.of(cause.getSuppressed())).filter(SneakyThrows::isFatal).findFirst().ifPresent(SneakyThrows::propagate);
            }
        }
    }
}

