/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ErrorHandler;
import io.jooby.MediaType;
import io.jooby.StatusCode;
import io.jooby.XSS;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;

public class DefaultErrorHandler
implements ErrorHandler {
    private final Set<StatusCode> muteCodes = new HashSet<StatusCode>();
    private final Set<Class> muteTypes = new HashSet<Class>();

    @NonNull
    public DefaultErrorHandler mute(StatusCode ... statusCodes) {
        this.muteCodes.addAll(List.of(statusCodes));
        return this;
    }

    @NonNull
    public DefaultErrorHandler mute(Class<? extends Exception> ... exceptionTypes) {
        this.muteTypes.addAll(List.of(exceptionTypes));
        return this;
    }

    protected void log(Context ctx, Throwable cause, StatusCode code) {
        Logger log = ctx.getRouter().getLog();
        if (this.isMuted(cause, code)) {
            log.debug(ErrorHandler.errorMessage(ctx, code), cause);
        } else {
            log.error(ErrorHandler.errorMessage(ctx, code), cause);
        }
    }

    @Override
    public void apply(@NonNull Context ctx, @NonNull Throwable cause, @NonNull StatusCode code) {
        this.log(ctx, cause, code);
        MediaType type = ctx.accept(Arrays.asList(MediaType.html, MediaType.json, MediaType.text));
        if (MediaType.json.equals(type)) {
            String message = Optional.ofNullable(cause.getMessage()).orElse(code.reason());
            ctx.setResponseType(MediaType.json).setResponseCode(code).send("{\"message\":\"" + XSS.json(message) + "\",\"statusCode\":" + code.value() + ",\"reason\":\"" + code.reason() + "\"}");
        } else if (MediaType.text.equals(type)) {
            StringBuilder message = new StringBuilder();
            message.append(ctx.getMethod()).append(" ").append(ctx.getRequestPath()).append(" ");
            message.append(code.value()).append(" ").append(code.reason());
            if (cause.getMessage() != null) {
                message.append("\n").append(XSS.json(cause.getMessage()));
            }
            ctx.setResponseType(MediaType.text).setResponseCode(code).send(message.toString());
        } else {
            String message = cause.getMessage();
            StringBuilder html = new StringBuilder("<!doctype html>\n").append("<html>\n").append("<head>\n").append("<meta charset=\"utf-8\">\n").append("<style>\n").append("body {font-family: \"open sans\",sans-serif; margin-left: 20px;}\n").append("h1 {font-weight: 300; line-height: 44px; margin: 25px 0 0 0;}\n").append("h2 {font-size: 16px;font-weight: 300; line-height: 44px; margin: 0;}\n").append("footer {font-weight: 300; line-height: 44px; margin-top: 10px;}\n").append("hr {background-color: #f7f7f9;}\n").append("div.trace {border:1px solid #e1e1e8; background-color: #f7f7f9;}\n").append("p {padding-left: 20px;}\n").append("p.tab {padding-left: 40px;}\n").append("</style>\n").append("<title>").append(code).append("</title>\n").append("<body>\n").append("<h1>").append(code.reason()).append("</h1>\n").append("<hr>\n");
            if (message != null && !message.equals(code.toString())) {
                html.append("<h2>message: ").append(XSS.html(message)).append("</h2>\n");
            }
            html.append("<h2>status code: ").append(code.value()).append("</h2>\n");
            html.append("</body>\n").append("</html>");
            ctx.setResponseType(MediaType.html).setResponseCode(code).send(html.toString());
        }
    }

    protected boolean isMuted(Throwable cause, StatusCode statusCode) {
        return this.muteCodes.contains(statusCode) || this.muteTypes.stream().anyMatch(type -> type == cause.getClass()) || this.muteTypes.stream().anyMatch(type -> type.isInstance(cause));
    }
}

