/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.DefaultErrorHandler;
import io.jooby.StatusCode;

public interface ErrorHandler {
    public void apply(@NonNull Context var1, @NonNull Throwable var2, @NonNull StatusCode var3);

    @NonNull
    default public ErrorHandler then(@NonNull ErrorHandler next) {
        return (ctx, cause, statusCode) -> {
            this.apply(ctx, cause, statusCode);
            if (!ctx.isResponseStarted()) {
                next.apply(ctx, cause, statusCode);
            }
        };
    }

    @NonNull
    public static String errorMessage(@NonNull Context ctx, @NonNull StatusCode statusCode) {
        return ctx.getMethod() + " " + ctx.getRequestPath() + " " + statusCode.value() + " " + statusCode.reason();
    }

    @NonNull
    public static DefaultErrorHandler create() {
        return new DefaultErrorHandler();
    }
}

