/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.SneakyThrows;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface LoggingService {
    public String getPropertyName();

    public List<String> getLogFileName();

    public void logOff(List<String> var1, SneakyThrows.Runnable var2);

    public static String configure(@NonNull ClassLoader classLoader, @NonNull List<String> names) {
        LoggingService loggingService;
        String[] keys2;
        for (String key : keys2 = new String[]{"logback.configurationFile", "log4j.configurationFile"}) {
            String file = LoggingService.property(key);
            if (file == null) continue;
            System.setProperty(key, file);
            return file;
        }
        Optional<LoggingService> lookup = ServiceLoader.load(LoggingService.class, classLoader).findFirst();
        if (lookup.isEmpty()) {
            return null;
        }
        Path userdir = Stream.of(System.getProperty("jooby.dir"), System.getProperty("user.dir")).filter(Objects::nonNull).map(x$0 -> Paths.get(x$0, new String[0])).findFirst().orElseThrow(() -> new IllegalStateException("No base directory found"));
        List<Object> resources = LoggingService.logFiles(userdir, names, (loggingService = lookup.get()).getLogFileName());
        if (resources.isEmpty()) {
            return null;
        }
        Optional<Path> logPath = resources.stream().filter(Path.class::isInstance).map(Path.class::cast).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toAbsolutePath).filter(it -> !LoggingService.isBinary(it)).findFirst();
        if (logPath.isPresent()) {
            System.setProperty(loggingService.getPropertyName(), logPath.get().toString());
            return logPath.get().toString();
        }
        Optional<Map.Entry> logResource = resources.stream().filter(String.class::isInstance).map(String.class::cast).map(it -> {
            URL found = classLoader.getResource((String)it);
            Map.Entry<String, URL> result = null;
            if (found != null) {
                result = Map.entry(it, found);
            }
            return result;
        }).filter(Objects::nonNull).findFirst();
        if (logResource.isPresent()) {
            System.setProperty(loggingService.getPropertyName(), (String)logResource.get().getKey());
            return ((URL)logResource.get().getValue()).toString();
        }
        return null;
    }

    public static boolean isBinary(Path path) {
        Set<String> bin = Set.of("target", "build", "bin");
        return StreamSupport.stream(path.spliterator(), false).anyMatch(it -> bin.contains(it.toString()));
    }

    private static List<Object> logFiles(Path basedir, List<String> profiles, List<String> logFileNames) {
        for (String logFileName : logFileNames) {
            String fileExt;
            int extensionStart;
            String fileName = logFileName.substring(0, extensionStart = logFileName.lastIndexOf(46));
            List<Object> files = LoggingService.logFile(basedir, profiles, fileName, fileExt = logFileName.substring(extensionStart));
            if (files.isEmpty()) continue;
            return files;
        }
        return Collections.emptyList();
    }

    private static List<Object> logFile(Path basedir, List<String> profiles, String name, String ext) {
        Path confdir = basedir.resolve("conf");
        ArrayList<Object> result = new ArrayList<Object>();
        for (String profile : profiles) {
            String logenvfile = name + "." + profile + ext;
            result.add(confdir.resolve(logenvfile));
            result.add(basedir.resolve(logenvfile));
            result.add(logenvfile);
        }
        String logfile = name + ext;
        result.add(confdir.resolve(logfile));
        result.add(basedir.resolve(logfile));
        result.add(logfile);
        return result;
    }

    private static String property(String name) {
        return System.getProperty(name, System.getenv(name));
    }
}

