/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.MapModelAndView;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ModelAndView<T> {
    private final String view;
    protected final T model;
    private Locale locale;

    public ModelAndView(@NonNull String view, @NonNull T model) {
        this.view = view;
        this.model = model;
    }

    public static MapModelAndView map(@NonNull String view) {
        return new MapModelAndView(view);
    }

    public static MapModelAndView map(@NonNull String view, @NonNull Map<String, Object> model) {
        return new MapModelAndView(view, model);
    }

    public ModelAndView<T> setLocale(@Nullable Locale locale) {
        this.locale = locale;
        return this;
    }

    public T getModel() {
        return this.model;
    }

    public String getView() {
        return this.view;
    }

    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    public String toString() {
        return this.view;
    }

    public static class UnsupportedModelAndView
    extends IllegalArgumentException {
        public UnsupportedModelAndView(Class<?> ... supported) {
            super("Only " + Set.of(supported).stream().map(Class::getName).collect(Collectors.joining(", ")) + " are supported");
        }
    }
}

