/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.MediaType;
import io.jooby.Router;
import io.jooby.SneakyThrows;
import io.jooby.handler.Asset;
import io.jooby.handler.AssetSource;
import io.jooby.internal.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class OpenAPIModule
implements Extension {
    private final String openAPIPath;
    private String swaggerUIPath = "/swagger";
    private String redocPath = "/redoc";
    private EnumSet<Format> format = EnumSet.of(Format.JSON, Format.YAML);
    private final Set<String> customFiles = new LinkedHashSet<String>();
    private String contextPath;

    public OpenAPIModule(@NonNull String path) {
        this.openAPIPath = Router.normalizePath(path);
    }

    public OpenAPIModule() {
        this("/");
    }

    @NonNull
    public OpenAPIModule file(@NonNull String path) {
        this.customFiles.add(path);
        return this;
    }

    @NonNull
    public OpenAPIModule contextPath(@NonNull String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @NonNull
    public OpenAPIModule swaggerUI(@NonNull String path) {
        this.swaggerUIPath = Router.normalizePath(path);
        return this;
    }

    @NonNull
    public OpenAPIModule redoc(@NonNull String path) {
        this.redocPath = Router.normalizePath(path);
        return this;
    }

    @NonNull
    public OpenAPIModule format(Format ... format) {
        this.format = EnumSet.copyOf(Arrays.asList(format));
        return this;
    }

    @Override
    public void install(@NonNull Jooby application) throws Exception {
        Map<String, String> filePaths = this.computeOpenAPIFiles(application);
        filePaths.forEach((path, source) -> application.assets(OpenAPIModule.fullPath(this.openAPIPath, path), (String)source));
        this.configureUI(application);
    }

    private Map<String, String> computeOpenAPIFiles(Jooby application) {
        LinkedHashMap<String, String> filePaths = new LinkedHashMap<String, String>();
        if (this.customFiles.isEmpty()) {
            String dir = Optional.ofNullable(application.getBasePackage()).orElse("/").replace(".", "/");
            String appName = application.getClass().getSimpleName().replace("Jooby", "openapi").replace("Kooby", "openapi");
            for (Format ext : this.format) {
                String filename = String.format("/%s.%s", appName, ext.name().toLowerCase());
                String openAPIFileLocation = Router.normalizePath(dir) + filename;
                filePaths.put("/openapi." + ext.name().toLowerCase(), openAPIFileLocation);
            }
        } else {
            for (String file : this.customFiles) {
                filePaths.put("/openapi." + Format.from(file).name().toLowerCase(), file);
            }
        }
        return filePaths;
    }

    private void configureUI(Jooby application) {
        HashMap<String, SneakyThrows.Consumer2<Jooby, AssetSource>> ui = new HashMap<String, SneakyThrows.Consumer2<Jooby, AssetSource>>();
        ui.put("swagger-ui", this::swaggerUI);
        ui.put("redoc", this::redoc);
        ClassLoader classLoader = application.getClassLoader();
        for (Map.Entry e : ui.entrySet()) {
            String name = (String)e.getKey();
            if (classLoader.getResource(name + "/index.html") == null) continue;
            if (this.format.contains((Object)Format.JSON)) {
                SneakyThrows.Consumer2 consumer = (SneakyThrows.Consumer2)e.getValue();
                consumer.accept(application, AssetSource.create(classLoader, name));
                continue;
            }
            application.getLog().debug("{} is disabled when json format is not supported", (Object)name);
        }
    }

    private void redoc(Jooby application, AssetSource source) throws Exception {
        String openAPIJSON = OpenAPIModule.fullPath(OpenAPIModule.fullPath(this.contextPath(application), this.openAPIPath), "/openapi.json");
        OpenAPISource customSource = new OpenAPISource().put("index.html", OpenAPIModule.processAsset(source, MediaType.html, "index.html", "${openAPIPath}", openAPIJSON, "${redocPath}", OpenAPIModule.fullPath(this.contextPath(application), this.redocPath)));
        application.assets(this.redocPath + "/?*", customSource, source);
    }

    private void swaggerUI(Jooby application, AssetSource source) throws Exception {
        String openAPIJSON = OpenAPIModule.fullPath(OpenAPIModule.fullPath(this.contextPath(application), this.openAPIPath), "/openapi.json");
        OpenAPISource customSource = new OpenAPISource().put("index.html", OpenAPIModule.processAsset(source, MediaType.html, "index.html", "${swaggerPath}", OpenAPIModule.fullPath(this.contextPath(application), this.swaggerUIPath))).put("swagger-initializer.js", OpenAPIModule.processAsset(source, MediaType.html, "swagger-initializer.js", "${openAPIPath}", openAPIJSON));
        application.assets(this.swaggerUIPath + "/?*", customSource, source);
    }

    private static Asset processAsset(AssetSource source, MediaType type, String resource, String ... replacements) throws Exception {
        try (Asset asset = source.resolve(resource);){
            String content = IOUtils.toString(asset.stream(), StandardCharsets.UTF_8);
            for (int i = 0; i < replacements.length; i += 2) {
                content = content.replace(replacements[i], replacements[i + 1]);
            }
            OpenAPIAsset openAPIAsset = new OpenAPIAsset(type, content.getBytes(StandardCharsets.UTF_8), asset.getLastModified());
            return openAPIAsset;
        }
    }

    private static String fullPath(String contextPath, String path) {
        return Router.noTrailingSlash(Router.normalizePath(contextPath + path));
    }

    private String contextPath(Jooby application) {
        return this.contextPath == null ? application.getContextPath() : this.contextPath;
    }

    public static enum Format {
        JSON,
        YAML;


        public static Format from(@NonNull String filePath) {
            for (Format value : Format.values()) {
                if (!filePath.endsWith("." + value.name().toLowerCase())) continue;
                return value;
            }
            throw new IllegalArgumentException("Unsupported format: " + filePath);
        }
    }

    private static class OpenAPISource
    implements AssetSource {
        private Map<String, Asset> assets = new HashMap<String, Asset>();

        private OpenAPISource() {
        }

        public OpenAPISource put(String key, Asset asset) {
            this.assets.put(key, asset);
            return this;
        }

        @Override
        @Nullable
        public Asset resolve(@NonNull String path) {
            return this.assets.get(path);
        }
    }

    private static class OpenAPIAsset
    implements Asset {
        private long lastModified;
        private byte[] content;
        private MediaType type;

        OpenAPIAsset(MediaType type, byte[] content, long lastModified) {
            this.content = content;
            this.type = type;
            this.lastModified = lastModified;
        }

        @Override
        public long getSize() {
            return this.content.length;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        @NonNull
        public MediaType getContentType() {
            return this.type;
        }

        @Override
        public InputStream stream() {
            return new ByteArrayInputStream(this.content);
        }

        @Override
        public void close() throws Exception {
        }
    }
}

