/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;

public final class RequestScope {
    private static final ThreadLocal<Map<Object, Object>> CONTEXT_TL = new ThreadLocal();

    private RequestScope() {
    }

    public static boolean hasBind(@NonNull Object key) {
        return RequestScope.get(key) != null;
    }

    @Nullable
    public static <T> T bind(@NonNull Object key, @NonNull T value) {
        return (T)RequestScope.threadMap(true).put(key, value);
    }

    @Nullable
    public static <T> T unbind(@NonNull Object key) {
        Map<Object, Object> contextMap = RequestScope.threadMap();
        Object existing = null;
        if (contextMap != null) {
            existing = contextMap.remove(key);
            RequestScope.doCleanup();
        }
        return (T)existing;
    }

    @Nullable
    public static <T> T get(@NonNull Object key) {
        Map<Object, Object> contextMap = RequestScope.threadMap();
        if (contextMap == null) {
            return null;
        }
        return (T)contextMap.get(key);
    }

    public static ThreadLocal<Map<Object, Object>> threadLocal() {
        return CONTEXT_TL;
    }

    private static Map<Object, Object> threadMap() {
        return RequestScope.threadMap(false);
    }

    private static Map<Object, Object> threadMap(boolean createMap) {
        Map<Object, Object> contextMap = CONTEXT_TL.get();
        if (contextMap == null && createMap) {
            contextMap = new HashMap<Object, Object>();
            CONTEXT_TL.set(contextMap);
        }
        return contextMap;
    }

    private static void doCleanup() {
        Map<Object, Object> ctx = RequestScope.threadMap(false);
        if (ctx != null && ctx.isEmpty()) {
            CONTEXT_TL.remove();
        }
    }
}

