/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.MediaType;
import io.jooby.Route;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RouteSet {
    private List<Route> routes;
    private List<String> tags = Collections.EMPTY_LIST;
    private String summary;
    private String description;

    @NonNull
    public List<Route> getRoutes() {
        return this.routes;
    }

    @NonNull
    public RouteSet setRoutes(@NonNull List<Route> routes) {
        this.routes = routes;
        return this;
    }

    @NonNull
    public RouteSet produces(MediaType ... produces) {
        return this.setProduces(Arrays.asList(produces));
    }

    @NonNull
    public RouteSet setProduces(@NonNull Collection<MediaType> produces) {
        this.routes.forEach(it -> {
            if (it.getProduces().isEmpty()) {
                it.setProduces(produces);
            }
        });
        return this;
    }

    @NonNull
    public RouteSet consumes(MediaType ... consumes) {
        return this.setConsumes(Arrays.asList(consumes));
    }

    @NonNull
    public RouteSet setConsumes(@NonNull Collection<MediaType> consumes) {
        this.routes.forEach(it -> {
            if (it.getConsumes().isEmpty()) {
                it.setConsumes(consumes);
            }
        });
        return this;
    }

    @NonNull
    public RouteSet setAttributes(@NonNull Map<String, Object> attributes) {
        this.routes.forEach(it -> attributes.forEach((k, v) -> it.getAttributes().putIfAbsent((String)k, v)));
        return this;
    }

    @NonNull
    public RouteSet attribute(@NonNull String name, @NonNull Object value) {
        this.routes.forEach(it -> it.getAttributes().putIfAbsent(name, value));
        return this;
    }

    @NonNull
    public RouteSet setExecutorKey(@Nullable String executorKey) {
        this.routes.forEach(it -> it.setExecutorKey(Optional.ofNullable(it.getExecutorKey()).orElse(executorKey)));
        return this;
    }

    @NonNull
    public List<String> getTags() {
        return this.tags;
    }

    @NonNull
    public RouteSet setTags(@NonNull List<String> tags) {
        if (this.tags == Collections.EMPTY_LIST) {
            this.tags = new ArrayList<String>();
        }
        this.routes.forEach(it -> tags.forEach(it::addTag));
        return this;
    }

    @NonNull
    public RouteSet tags(String ... tags) {
        return this.setTags(Arrays.asList(tags));
    }

    @Nullable
    public String getSummary() {
        return this.summary;
    }

    @NonNull
    public RouteSet summary(@Nullable String summary) {
        return this.setSummary(summary);
    }

    @NonNull
    public RouteSet setSummary(@Nullable String summary) {
        this.summary = summary;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public RouteSet setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @NonNull
    public RouteSet description(@Nullable String description) {
        return this.setDescription(description);
    }
}

