/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.MessageEncoder;
import io.jooby.Route;
import io.jooby.SneakyThrows;
import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferFactory;
import java.nio.charset.StandardCharsets;
import java.util.function.IntPredicate;

public class ServerSentMessage {
    private static final byte SEPARATOR = 10;
    private static final byte[] ID = "id:".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EVENT = "event:".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RETRY = "retry:".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DATA = "data: ".getBytes(StandardCharsets.UTF_8);
    private Object id;
    private String event;
    private final Object data;
    private Long retry;

    public ServerSentMessage(@NonNull Object data) {
        this.data = data;
    }

    @Nullable
    public Object getId() {
        return this.id;
    }

    @NonNull
    public ServerSentMessage setId(@Nullable Object id) {
        this.id = id == null ? null : id.toString();
        return this;
    }

    @Nullable
    public String getEvent() {
        return this.event;
    }

    @NonNull
    public ServerSentMessage setEvent(@Nullable String event) {
        this.event = event;
        return this;
    }

    @NonNull
    public Object getData() {
        return this.data;
    }

    @Nullable
    public Long getRetry() {
        return this.retry;
    }

    @NonNull
    public ServerSentMessage setRetry(@Nullable Long retry) {
        this.retry = retry;
        return this;
    }

    @NonNull
    public DataBuffer encode(@NonNull Context ctx) {
        try {
            Route route = ctx.getRoute();
            MessageEncoder encoder = route.getEncoder();
            DataBufferFactory bufferFactory = ctx.getBufferFactory();
            DataBuffer buffer = bufferFactory.allocateBuffer();
            DataBuffer message = encoder.encode(ctx, this.data);
            if (this.id != null) {
                buffer.write(ID);
                buffer.write(this.id.toString().getBytes(StandardCharsets.UTF_8));
                buffer.write((byte)10);
            }
            if (this.event != null) {
                buffer.write(EVENT);
                buffer.write(this.event.getBytes(StandardCharsets.UTF_8));
                buffer.write((byte)10);
            }
            if (this.retry != null) {
                buffer.write(RETRY);
                buffer.write(this.retry.toString().getBytes(StandardCharsets.UTF_8));
                buffer.write((byte)10);
            }
            buffer.write(DATA);
            IntPredicate nl = ch -> ch == 10;
            int i = message.indexOf(nl, 0);
            while (i > 0) {
                buffer.write(message.split(i + 1));
                if (message.readableByteCount() > 0) {
                    buffer.write(DATA);
                }
                i = message.indexOf(nl, 1);
            }
            buffer.write(message);
            buffer.write((byte)10);
            buffer.write((byte)10);
            return buffer;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate(x);
        }
    }
}

