/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public final class ServiceKey<T> {
    private final Class<T> type;
    private final int hashCode;
    private final String name;

    private ServiceKey(Class<T> type, String name) {
        this.type = type;
        this.name = name;
        this.hashCode = Objects.hash(type, name);
    }

    @NonNull
    public Class<T> getType() {
        return this.type;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceKey) {
            ServiceKey that = (ServiceKey)obj;
            return this.type == that.type && Objects.equals(this.name, that.name);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.name == null) {
            return this.type.getName();
        }
        return this.type.getName() + "(" + this.name + ")";
    }

    @NonNull
    public static <T> ServiceKey<T> key(@NonNull Class<T> type) {
        return new ServiceKey<T>(type, null);
    }

    @NonNull
    public static <T> ServiceKey<T> key(@NonNull Class<T> type, @NonNull String name) {
        return new ServiceKey<T>(type, name);
    }
}

