/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.Value;
import io.jooby.internal.SessionImpl;
import java.time.Instant;
import java.util.Map;

public interface Session {
    public static final String NAME = "session";

    @Nullable
    public String getId();

    @NonNull
    public Session setId(@Nullable String var1);

    @NonNull
    public Value get(@NonNull String var1);

    @NonNull
    default public Session put(@NonNull String name, int value) {
        return this.put(name, Integer.toString(value));
    }

    @NonNull
    default public Session put(@NonNull String name, long value) {
        return this.put(name, Long.toString(value));
    }

    @NonNull
    default public Session put(@NonNull String name, @NonNull CharSequence value) {
        return this.put(name, value.toString());
    }

    @NonNull
    public Session put(@NonNull String var1, @NonNull String var2);

    @NonNull
    default public Session put(@NonNull String name, float value) {
        return this.put(name, Float.toString(value));
    }

    @NonNull
    default public Session put(@NonNull String name, double value) {
        return this.put(name, Double.toString(value));
    }

    @NonNull
    default public Session put(@NonNull String name, boolean value) {
        return this.put(name, Boolean.toString(value));
    }

    @NonNull
    default public Session put(@NonNull String name, @NonNull Number value) {
        return this.put(name, value.toString());
    }

    @NonNull
    public Value remove(@NonNull String var1);

    @NonNull
    public Map<String, String> toMap();

    @NonNull
    public Instant getCreationTime();

    @NonNull
    public Session setCreationTime(@NonNull Instant var1);

    @NonNull
    public Instant getLastAccessedTime();

    @NonNull
    public Session setLastAccessedTime(@NonNull Instant var1);

    public boolean isNew();

    @NonNull
    public Session setNew(boolean var1);

    public boolean isModify();

    @NonNull
    public Session setModify(boolean var1);

    public Session clear();

    public void destroy();

    public Session renewId();

    @NonNull
    public static Session create(@NonNull Context ctx, @Nullable String id) {
        return new SessionImpl(ctx, id);
    }

    @NonNull
    public static Session create(@NonNull Context ctx, @Nullable String id, @NonNull Map<String, String> data) {
        return new SessionImpl(ctx, id, data);
    }
}

