/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.Session;
import io.jooby.SessionToken;
import io.jooby.SneakyThrows;
import io.jooby.internal.MemorySessionStore;
import io.jooby.internal.SignedSessionStore;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public interface SessionStore {
    public static final int DEFAULT_TIMEOUT = 30;

    @NonNull
    public Session newSession(@NonNull Context var1);

    @Nullable
    public Session findSession(@NonNull Context var1);

    public void deleteSession(@NonNull Context var1, @NonNull Session var2);

    public void touchSession(@NonNull Context var1, @NonNull Session var2);

    public void saveSession(@NonNull Context var1, @NonNull Session var2);

    public void renewSessionId(@NonNull Context var1, @NonNull Session var2);

    @NonNull
    public static SessionStore memory(int timeout) {
        return SessionStore.memory(SessionToken.SID, Duration.ofSeconds(timeout));
    }

    @NonNull
    public static SessionStore memory() {
        return SessionStore.memory(SessionToken.SID);
    }

    @NonNull
    public static SessionStore memory(@NonNull Duration timeout) {
        return SessionStore.memory(SessionToken.SID, timeout);
    }

    @NonNull
    public static SessionStore memory(@NonNull Cookie cookie) {
        return SessionStore.memory(SessionToken.cookieId(cookie));
    }

    @NonNull
    public static SessionStore memory(@NonNull Cookie cookie, @NonNull Duration timeout) {
        return SessionStore.memory(SessionToken.cookieId(cookie), timeout);
    }

    @NonNull
    public static SessionStore memory(@NonNull SessionToken token) {
        return new MemorySessionStore(token, Duration.ofMinutes(30L));
    }

    @NonNull
    public static SessionStore memory(@NonNull SessionToken token, @NonNull Duration timeout) {
        return new MemorySessionStore(token, timeout);
    }

    @NonNull
    public static SessionStore signed(@NonNull String secret) {
        return SessionStore.signed(secret, SessionToken.SID);
    }

    @NonNull
    public static SessionStore signed(@NonNull String secret, @NonNull Cookie cookie) {
        return SessionStore.signed(secret, SessionToken.signedCookie(cookie));
    }

    @NonNull
    public static SessionStore signed(@NonNull String secret, @NonNull SessionToken token) {
        SneakyThrows.Function<String, Map<String, String>> decoder = value -> {
            String unsign = Cookie.unsign(value, secret);
            if (unsign == null) {
                return null;
            }
            return Cookie.decode(unsign);
        };
        SneakyThrows.Function<Map<String, String>, String> encoder = attributes -> Cookie.sign(Cookie.encode(attributes), secret);
        return SessionStore.signed(token, decoder, encoder);
    }

    @NonNull
    public static SessionStore signed(@NonNull SessionToken token, @NonNull Function<String, Map<String, String>> decoder, @NonNull Function<Map<String, String>, String> encoder) {
        return new SignedSessionStore(token, decoder, encoder);
    }

    public static abstract class InMemory
    implements SessionStore {
        private SessionToken token;

        protected InMemory(@NonNull SessionToken token) {
            this.token = token;
        }

        @Override
        @NonNull
        public Session newSession(@NonNull Context ctx) {
            String sessionId = this.token.newToken();
            Data data = this.getOrCreate(sessionId, sid -> new Data(Instant.now(), Instant.now(), new ConcurrentHashMap()));
            Session session = this.restore(ctx, sessionId, data);
            this.token.saveToken(ctx, sessionId);
            return session;
        }

        @NonNull
        public SessionToken getToken() {
            return this.token;
        }

        @NonNull
        public SessionStore setToken(@NonNull SessionToken token) {
            this.token = token;
            return this;
        }

        @NonNull
        protected abstract Data getOrCreate(@NonNull String var1, @NonNull Function<String, Data> var2);

        @Nullable
        protected abstract Data getOrNull(@NonNull String var1);

        @Nullable
        protected abstract Data remove(@NonNull String var1);

        protected abstract void put(@NonNull String var1, @NonNull Data var2);

        @Override
        public Session findSession(Context ctx) {
            String sessionId = this.token.findToken(ctx);
            if (sessionId == null) {
                return null;
            }
            Data data = this.getOrNull(sessionId);
            if (data != null) {
                Session session = this.restore(ctx, sessionId, data);
                this.token.saveToken(ctx, sessionId);
                return session;
            }
            return null;
        }

        @Override
        public void deleteSession(@NonNull Context ctx, @NonNull Session session) {
            String sessionId = session.getId();
            this.remove(sessionId);
            this.token.deleteToken(ctx, sessionId);
        }

        @Override
        public void touchSession(@NonNull Context ctx, @NonNull Session session) {
            this.saveSession(ctx, session);
            this.token.saveToken(ctx, session.getId());
        }

        @Override
        public void saveSession(Context ctx, @NonNull Session session) {
            String sessionId = session.getId();
            this.put(sessionId, new Data(session.getCreationTime(), Instant.now(), session.toMap()));
        }

        @Override
        public void renewSessionId(@NonNull Context ctx, @NonNull Session session) {
            String oldId = session.getId();
            Data data = this.remove(oldId);
            if (data != null) {
                String newId = this.token.newToken();
                session.setId(newId);
                this.put(newId, data);
            }
        }

        private Session restore(Context ctx, String sessionId, Data data) {
            return Session.create(ctx, sessionId, data.hash).setLastAccessedTime(data.lastAccessedTime).setCreationTime(data.creationTime);
        }

        protected static class Data {
            private Instant lastAccessedTime;
            private Instant creationTime;
            private Map hash;

            public Data(Instant creationTime, Instant lastAccessedTime, Map hash) {
                this.creationTime = creationTime;
                this.lastAccessedTime = lastAccessedTime;
                this.hash = hash;
            }

            public boolean isExpired(Duration timeout) {
                Duration timeElapsed = Duration.between(this.lastAccessedTime, Instant.now());
                return timeElapsed.compareTo(timeout) > 0;
            }
        }
    }
}

