/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

public final class StatusCode {
    public static final int CONTINUE_CODE = 100;
    public static final StatusCode CONTINUE = new StatusCode(100, "Continue");
    public static final int SWITCHING_PROTOCOLS_CODE = 101;
    public static final StatusCode SWITCHING_PROTOCOLS = new StatusCode(101, "Switching Protocols");
    public static final int PROCESSING_CODE = 102;
    public static final StatusCode PROCESSING = new StatusCode(102, "Processing");
    public static final int CHECKPOINT_CODE = 103;
    public static final StatusCode CHECKPOINT = new StatusCode(103, "Checkpoint");
    public static final int OK_CODE = 200;
    public static final StatusCode OK = new StatusCode(200, "Success");
    public static final int CREATED_CODE = 201;
    public static final StatusCode CREATED = new StatusCode(201, "Created");
    public static final int ACCEPTED_CODE = 202;
    public static final StatusCode ACCEPTED = new StatusCode(202, "Accepted");
    public static final int NON_AUTHORITATIVE_INFORMATION_CODE = 203;
    public static final StatusCode NON_AUTHORITATIVE_INFORMATION = new StatusCode(203, "Non-Authoritative Information");
    public static final int NO_CONTENT_CODE = 204;
    public static final StatusCode NO_CONTENT = new StatusCode(204, "No Content");
    public static final int RESET_CONTENT_CODE = 205;
    public static final StatusCode RESET_CONTENT = new StatusCode(205, "Reset Content");
    public static final int PARTIAL_CONTENT_CODE = 206;
    public static final StatusCode PARTIAL_CONTENT = new StatusCode(206, "Partial Content");
    public static final int MULTI_STATUS_CODE = 207;
    public static final StatusCode MULTI_STATUS = new StatusCode(207, "Multi-StatusCode");
    public static final int ALREADY_REPORTED_CODE = 208;
    public static final StatusCode ALREADY_REPORTED = new StatusCode(208, "Already Reported");
    public static final int IM_USED_CODE = 226;
    public static final StatusCode IM_USED = new StatusCode(226, "IM Used");
    public static final int MULTIPLE_CHOICES_CODE = 300;
    public static final StatusCode MULTIPLE_CHOICES = new StatusCode(300, "Multiple Choices");
    public static final int MOVED_PERMANENTLY_CODE = 301;
    public static final StatusCode MOVED_PERMANENTLY = new StatusCode(301, "Moved Permanently");
    public static final int FOUND_CODE = 302;
    public static final StatusCode FOUND = new StatusCode(302, "Found");
    public static final int SEE_OTHER_CODE = 303;
    public static final StatusCode SEE_OTHER = new StatusCode(303, "See Other");
    public static final int NOT_MODIFIED_CODE = 304;
    public static final StatusCode NOT_MODIFIED = new StatusCode(304, "Not Modified");
    public static final int USE_PROXY_CODE = 305;
    public static final StatusCode USE_PROXY = new StatusCode(305, "Use Proxy");
    public static final int TEMPORARY_REDIRECT_CODE = 307;
    public static final StatusCode TEMPORARY_REDIRECT = new StatusCode(307, "Temporary Redirect");
    public static final int RESUME_INCOMPLETE_CODE = 308;
    public static final StatusCode RESUME_INCOMPLETE = new StatusCode(308, "Resume Incomplete");
    public static final int BAD_REQUEST_CODE = 400;
    public static final StatusCode BAD_REQUEST = new StatusCode(400, "Bad Request");
    public static final int UNAUTHORIZED_CODE = 401;
    public static final StatusCode UNAUTHORIZED = new StatusCode(401, "Unauthorized");
    public static final int PAYMENT_REQUIRED_CODE = 402;
    public static final StatusCode PAYMENT_REQUIRED = new StatusCode(402, "Payment Required");
    public static final int FORBIDDEN_CODE = 403;
    public static final StatusCode FORBIDDEN = new StatusCode(403, "Forbidden");
    public static final int NOT_FOUND_CODE = 404;
    public static final StatusCode NOT_FOUND = new StatusCode(404, "Not Found");
    public static final int METHOD_NOT_ALLOWED_CODE = 405;
    public static final StatusCode METHOD_NOT_ALLOWED = new StatusCode(405, "Method Not Allowed");
    public static final int NOT_ACCEPTABLE_CODE = 406;
    public static final StatusCode NOT_ACCEPTABLE = new StatusCode(406, "Not Acceptable");
    public static final int PROXY_AUTHENTICATION_REQUIRED_CODE = 407;
    public static final StatusCode PROXY_AUTHENTICATION_REQUIRED = new StatusCode(407, "Proxy Authentication Required");
    public static final int REQUEST_TIMEOUT_CODE = 408;
    public static final StatusCode REQUEST_TIMEOUT = new StatusCode(408, "Request Timeout");
    public static final int CONFLICT_CODE = 409;
    public static final StatusCode CONFLICT = new StatusCode(409, "Conflict");
    public static final int GONE_CODE = 410;
    public static final StatusCode GONE = new StatusCode(410, "Gone");
    public static final int LENGTH_REQUIRED_CODE = 411;
    public static final StatusCode LENGTH_REQUIRED = new StatusCode(411, "Length Required");
    public static final int PRECONDITION_FAILED_CODE = 412;
    public static final StatusCode PRECONDITION_FAILED = new StatusCode(412, "Precondition Failed");
    public static final int REQUEST_ENTITY_TOO_LARGE_CODE = 413;
    public static final StatusCode REQUEST_ENTITY_TOO_LARGE = new StatusCode(413, "Request Entity Too Large");
    public static final int REQUEST_URI_TOO_LONG_CODE = 414;
    public static final StatusCode REQUEST_URI_TOO_LONG = new StatusCode(414, "Request-URI Too Long");
    public static final int UNSUPPORTED_MEDIA_TYPE_CODE = 415;
    public static final StatusCode UNSUPPORTED_MEDIA_TYPE = new StatusCode(415, "Unsupported Media Type");
    public static final int REQUESTED_RANGE_NOT_SATISFIABLE_CODE = 416;
    public static final StatusCode REQUESTED_RANGE_NOT_SATISFIABLE = new StatusCode(416, "Requested range not satisfiable");
    public static final int EXPECTATION_FAILED_CODE = 417;
    public static final StatusCode EXPECTATION_FAILED = new StatusCode(417, "Expectation Failed");
    public static final int I_AM_A_TEAPOT_CODE = 418;
    public static final StatusCode I_AM_A_TEAPOT = new StatusCode(418, "I'm a teapot");
    public static final int UNPROCESSABLE_ENTITY_CODE = 422;
    public static final StatusCode UNPROCESSABLE_ENTITY = new StatusCode(422, "Unprocessable Entity");
    public static final int LOCKED_CODE = 423;
    public static final StatusCode LOCKED = new StatusCode(423, "Locked");
    public static final int FAILED_DEPENDENCY_CODE = 424;
    public static final StatusCode FAILED_DEPENDENCY = new StatusCode(424, "Failed Dependency");
    public static final int UPGRADE_REQUIRED_CODE = 426;
    public static final StatusCode UPGRADE_REQUIRED = new StatusCode(426, "Upgrade Required");
    public static final int PRECONDITION_REQUIRED_CODE = 428;
    public static final StatusCode PRECONDITION_REQUIRED = new StatusCode(428, "Precondition Required");
    public static final int TOO_MANY_REQUESTS_CODE = 429;
    public static final StatusCode TOO_MANY_REQUESTS = new StatusCode(429, "Too Many Requests");
    public static final int REQUEST_HEADER_FIELDS_TOO_LARGE_CODE = 431;
    public static final StatusCode REQUEST_HEADER_FIELDS_TOO_LARGE = new StatusCode(431, "Request Header Fields Too Large");
    public static final int SERVER_ERROR_CODE = 500;
    public static final StatusCode SERVER_ERROR = new StatusCode(500, "Server Error");
    public static final int NOT_IMPLEMENTED_CODE = 501;
    public static final StatusCode NOT_IMPLEMENTED = new StatusCode(501, "Not Implemented");
    public static final int BAD_GATEWAY_CODE = 502;
    public static final StatusCode BAD_GATEWAY = new StatusCode(502, "Bad Gateway");
    public static final int SERVICE_UNAVAILABLE_CODE = 503;
    public static final StatusCode SERVICE_UNAVAILABLE = new StatusCode(503, "Service Unavailable");
    public static final int GATEWAY_TIMEOUT_CODE = 504;
    public static final StatusCode GATEWAY_TIMEOUT = new StatusCode(504, "Gateway Timeout");
    public static final int HTTP_VERSION_NOT_SUPPORTED_CODE = 505;
    public static final StatusCode HTTP_VERSION_NOT_SUPPORTED = new StatusCode(505, "HTTP Version not supported");
    public static final int VARIANT_ALSO_NEGOTIATES_CODE = 506;
    public static final StatusCode VARIANT_ALSO_NEGOTIATES = new StatusCode(506, "Variant Also Negotiates");
    public static final int INSUFFICIENT_STORAGE_CODE = 507;
    public static final StatusCode INSUFFICIENT_STORAGE = new StatusCode(507, "Insufficient Storage");
    public static final int LOOP_DETECTED_CODE = 508;
    public static final StatusCode LOOP_DETECTED = new StatusCode(508, "Loop Detected");
    public static final int BANDWIDTH_LIMIT_EXCEEDED_CODE = 509;
    public static final StatusCode BANDWIDTH_LIMIT_EXCEEDED = new StatusCode(509, "Bandwidth Limit Exceeded");
    public static final int NOT_EXTENDED_CODE = 510;
    public static final StatusCode NOT_EXTENDED = new StatusCode(510, "Not Extended");
    public static final int NETWORK_AUTHENTICATION_REQUIRED_CODE = 511;
    public static final StatusCode NETWORK_AUTHENTICATION_REQUIRED = new StatusCode(511, "Network Authentication Required");
    private final int value;
    private final String reason;

    private StatusCode(int value, String reason) {
        this.value = value;
        this.reason = reason;
    }

    public int value() {
        return this.value;
    }

    public String reason() {
        return this.reason;
    }

    public String toString() {
        return this.reason() + " (" + this.value + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatusCode) {
            return this.value == ((StatusCode)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public static StatusCode valueOf(int statusCode) {
        switch (statusCode) {
            case 100: {
                return CONTINUE;
            }
            case 101: {
                return SWITCHING_PROTOCOLS;
            }
            case 102: {
                return PROCESSING;
            }
            case 103: {
                return CHECKPOINT;
            }
            case 200: {
                return OK;
            }
            case 201: {
                return CREATED;
            }
            case 202: {
                return ACCEPTED;
            }
            case 203: {
                return NON_AUTHORITATIVE_INFORMATION;
            }
            case 204: {
                return NO_CONTENT;
            }
            case 205: {
                return RESET_CONTENT;
            }
            case 206: {
                return PARTIAL_CONTENT;
            }
            case 207: {
                return MULTI_STATUS;
            }
            case 208: {
                return ALREADY_REPORTED;
            }
            case 226: {
                return IM_USED;
            }
            case 300: {
                return MULTIPLE_CHOICES;
            }
            case 301: {
                return MOVED_PERMANENTLY;
            }
            case 302: {
                return FOUND;
            }
            case 303: {
                return SEE_OTHER;
            }
            case 304: {
                return NOT_MODIFIED;
            }
            case 305: {
                return USE_PROXY;
            }
            case 307: {
                return TEMPORARY_REDIRECT;
            }
            case 308: {
                return RESUME_INCOMPLETE;
            }
            case 400: {
                return BAD_REQUEST;
            }
            case 401: {
                return UNAUTHORIZED;
            }
            case 402: {
                return PAYMENT_REQUIRED;
            }
            case 403: {
                return FORBIDDEN;
            }
            case 404: {
                return NOT_FOUND;
            }
            case 405: {
                return METHOD_NOT_ALLOWED;
            }
            case 406: {
                return NOT_ACCEPTABLE;
            }
            case 407: {
                return PROXY_AUTHENTICATION_REQUIRED;
            }
            case 408: {
                return REQUEST_TIMEOUT;
            }
            case 409: {
                return CONFLICT;
            }
            case 410: {
                return GONE;
            }
            case 411: {
                return LENGTH_REQUIRED;
            }
            case 412: {
                return PRECONDITION_FAILED;
            }
            case 413: {
                return REQUEST_ENTITY_TOO_LARGE;
            }
            case 414: {
                return REQUEST_URI_TOO_LONG;
            }
            case 415: {
                return UNSUPPORTED_MEDIA_TYPE;
            }
            case 416: {
                return REQUESTED_RANGE_NOT_SATISFIABLE;
            }
            case 417: {
                return EXPECTATION_FAILED;
            }
            case 418: {
                return I_AM_A_TEAPOT;
            }
            case 422: {
                return UNPROCESSABLE_ENTITY;
            }
            case 423: {
                return LOCKED;
            }
            case 424: {
                return FAILED_DEPENDENCY;
            }
            case 426: {
                return UPGRADE_REQUIRED;
            }
            case 428: {
                return PRECONDITION_REQUIRED;
            }
            case 429: {
                return TOO_MANY_REQUESTS;
            }
            case 431: {
                return REQUEST_HEADER_FIELDS_TOO_LARGE;
            }
            case 500: {
                return SERVER_ERROR;
            }
            case 501: {
                return NOT_IMPLEMENTED;
            }
            case 502: {
                return BAD_GATEWAY;
            }
            case 503: {
                return SERVICE_UNAVAILABLE;
            }
            case 504: {
                return GATEWAY_TIMEOUT;
            }
            case 505: {
                return HTTP_VERSION_NOT_SUPPORTED;
            }
            case 506: {
                return VARIANT_ALSO_NEGOTIATES;
            }
            case 507: {
                return INSUFFICIENT_STORAGE;
            }
            case 508: {
                return LOOP_DETECTED;
            }
            case 509: {
                return BANDWIDTH_LIMIT_EXCEEDED;
            }
            case 510: {
                return NOT_EXTENDED;
            }
            case 511: {
                return NETWORK_AUTHENTICATION_REQUIRED;
            }
        }
        return new StatusCode(statusCode, Integer.toString(statusCode));
    }
}

