/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.Formdata;
import io.jooby.SneakyThrows;
import io.jooby.ValueNode;
import io.jooby.exception.MissingValueException;
import io.jooby.exception.TypeMismatchException;
import io.jooby.internal.ArrayValue;
import io.jooby.internal.HashValue;
import io.jooby.internal.HeadersValue;
import io.jooby.internal.MissingValue;
import io.jooby.internal.MultipartNode;
import io.jooby.internal.SingleValue;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface Value {
    default public long longValue() {
        try {
            return Long.parseLong(this.value());
        }
        catch (NumberFormatException x) {
            try {
                LocalDateTime date = LocalDateTime.parse(this.value(), Context.RFC1123);
                Instant instant = date.toInstant(ZoneOffset.UTC);
                return instant.toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
                throw new TypeMismatchException(this.name(), Long.TYPE, (Throwable)x);
            }
        }
    }

    default public long longValue(long defaultValue) {
        try {
            return this.longValue();
        }
        catch (MissingValueException x) {
            return defaultValue;
        }
    }

    default public int intValue() {
        try {
            return Integer.parseInt(this.value());
        }
        catch (NumberFormatException x) {
            throw new TypeMismatchException(this.name(), Integer.TYPE, (Throwable)x);
        }
    }

    default public int intValue(int defaultValue) {
        try {
            return this.intValue();
        }
        catch (MissingValueException x) {
            return defaultValue;
        }
    }

    default public byte byteValue() {
        try {
            return Byte.parseByte(this.value());
        }
        catch (NumberFormatException x) {
            throw new TypeMismatchException(this.name(), Byte.TYPE, (Throwable)x);
        }
    }

    default public byte byteValue(byte defaultValue) {
        try {
            return this.byteValue();
        }
        catch (MissingValueException x) {
            return defaultValue;
        }
    }

    default public float floatValue() {
        try {
            return Float.parseFloat(this.value());
        }
        catch (NumberFormatException x) {
            throw new TypeMismatchException(this.name(), Float.TYPE, (Throwable)x);
        }
    }

    default public float floatValue(float defaultValue) {
        try {
            return this.floatValue();
        }
        catch (MissingValueException x) {
            return defaultValue;
        }
    }

    default public double doubleValue() {
        try {
            return Double.parseDouble(this.value());
        }
        catch (NumberFormatException x) {
            throw new TypeMismatchException(this.name(), Double.TYPE, (Throwable)x);
        }
    }

    default public double doubleValue(double defaultValue) {
        try {
            return this.doubleValue();
        }
        catch (MissingValueException x) {
            return defaultValue;
        }
    }

    default public boolean booleanValue() {
        return Boolean.parseBoolean(this.value());
    }

    default public boolean booleanValue(boolean defaultValue) {
        try {
            return this.booleanValue();
        }
        catch (MissingValueException x) {
            return defaultValue;
        }
    }

    @NonNull
    default public String value(@NonNull String defaultValue) {
        try {
            return this.value();
        }
        catch (MissingValueException x) {
            return defaultValue;
        }
    }

    @Nullable
    default public String valueOrNull() {
        return this.value((String)null);
    }

    @NonNull
    default public <T> T value(@NonNull SneakyThrows.Function<String, T> fn) {
        return fn.apply(this.value());
    }

    @NonNull
    public String value();

    @NonNull
    public List<String> toList();

    @NonNull
    public Set<String> toSet();

    @NonNull
    default public <T extends Enum<T>> T toEnum(@NonNull SneakyThrows.Function<String, T> fn) {
        return this.toEnum(fn, String::toUpperCase);
    }

    @NonNull
    default public <T extends Enum<T>> T toEnum(@NonNull SneakyThrows.Function<String, T> fn, @NonNull Function<String, String> nameProvider) {
        return (T)((Enum)fn.apply(nameProvider.apply(this.value())));
    }

    @NonNull
    default public Optional<String> toOptional() {
        try {
            return Optional.of(this.value());
        }
        catch (MissingValueException x) {
            return Optional.empty();
        }
    }

    default public boolean isSingle() {
        return this instanceof SingleValue;
    }

    default public boolean isMissing() {
        return this instanceof MissingValue;
    }

    default public boolean isPresent() {
        return !this.isMissing();
    }

    default public boolean isArray() {
        return this instanceof ArrayValue;
    }

    default public boolean isObject() {
        return this instanceof HashValue;
    }

    @Nullable
    public String name();

    @NonNull
    default public <T> Optional<T> toOptional(@NonNull Class<T> type) {
        try {
            return Optional.ofNullable(this.to(type));
        }
        catch (MissingValueException x) {
            return Optional.empty();
        }
    }

    @NonNull
    default public <T> List<T> toList(@NonNull Class<T> type) {
        return Collections.singletonList(this.to(type));
    }

    @NonNull
    default public <T> Set<T> toSet(@NonNull Class<T> type) {
        return Collections.singleton(this.to(type));
    }

    @NonNull
    public <T> T to(@NonNull Class<T> var1);

    @Nullable
    public <T> T toNullable(@NonNull Class<T> var1);

    @NonNull
    public Map<String, List<String>> toMultimap();

    @NonNull
    default public Map<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        this.toMultimap().forEach((k, v) -> map.put((String)k, (String)v.get(0)));
        return map;
    }

    @NonNull
    public static ValueNode missing(@NonNull String name) {
        return new MissingValue(name);
    }

    @NonNull
    public static ValueNode value(@NonNull Context ctx, @NonNull String name, @NonNull String value) {
        return new SingleValue(ctx, name, value);
    }

    @NonNull
    public static ValueNode array(@NonNull Context ctx, @NonNull String name, @NonNull List<String> values2) {
        return new ArrayValue(ctx, name).add(values2);
    }

    @NonNull
    public static ValueNode create(Context ctx, @NonNull String name, @Nullable List<String> values2) {
        if (values2 == null || values2.size() == 0) {
            return Value.missing(name);
        }
        if (values2.size() == 1) {
            return Value.value(ctx, name, values2.get(0));
        }
        return new ArrayValue(ctx, name).add(values2);
    }

    @NonNull
    public static ValueNode create(Context ctx, @NonNull String name, @Nullable String value) {
        if (value == null) {
            return Value.missing(name);
        }
        return Value.value(ctx, name, value);
    }

    @NonNull
    public static ValueNode hash(Context ctx, @NonNull Map<String, Collection<String>> values2) {
        HashValue node = new HashValue(ctx, null);
        node.put(values2);
        return node;
    }

    @NonNull
    public static Formdata formdata(Context ctx) {
        return new MultipartNode(ctx);
    }

    @NonNull
    public static ValueNode headers(Context ctx, @NonNull Map<String, Collection<String>> values2) {
        HeadersValue node = new HeadersValue(ctx);
        node.put(values2);
        return node;
    }
}

