/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;

public class WebSocketCloseStatus {
    public static final int NORMAL_CODE = 1000;
    public static final int GOING_AWAY_CODE = 1001;
    public static final int PROTOCOL_ERROR_CODE = 1002;
    public static final int NOT_ACCEPTABLE_CODE = 1003;
    public static final int HARSH_DISCONNECT_CODE = 1006;
    public static final int BAD_DATA_CODE = 1007;
    public static final int POLICY_VIOLATION_CODE = 1008;
    public static final int TOO_BIG_TO_PROCESS_CODE = 1009;
    public static final int REQUIRED_EXTENSION_CODE = 1010;
    public static final int SERVER_ERROR_CODE = 1011;
    public static final int SERVICE_RESTARTED_CODE = 1012;
    public static final int SERVICE_OVERLOAD_CODE = 1013;
    public static final WebSocketCloseStatus NORMAL = new WebSocketCloseStatus(1000, "Normal");
    public static final WebSocketCloseStatus GOING_AWAY = new WebSocketCloseStatus(1001, "Going away");
    public static final WebSocketCloseStatus PROTOCOL_ERROR = new WebSocketCloseStatus(1002, "Protocol error");
    public static final WebSocketCloseStatus NOT_ACCEPTABLE = new WebSocketCloseStatus(1003, "Not acceptable");
    public static final WebSocketCloseStatus HARSH_DISCONNECT = new WebSocketCloseStatus(1006, "Harsh disconnect");
    public static final WebSocketCloseStatus BAD_DATA = new WebSocketCloseStatus(1007, "Bad data");
    public static final WebSocketCloseStatus POLICY_VIOLATION = new WebSocketCloseStatus(1008, "Policy violation");
    public static final WebSocketCloseStatus TOO_BIG_TO_PROCESS = new WebSocketCloseStatus(1009, "Too big to process");
    public static final WebSocketCloseStatus REQUIRED_EXTENSION = new WebSocketCloseStatus(1010, "Required extension");
    public static final WebSocketCloseStatus SERVER_ERROR = new WebSocketCloseStatus(1011, "Server error");
    public static final WebSocketCloseStatus SERVICE_RESTARTED = new WebSocketCloseStatus(1012, "Service restarted");
    public static final WebSocketCloseStatus SERVICE_OVERLOAD = new WebSocketCloseStatus(1013, "Service overload");
    private int code;
    private String reason;

    public WebSocketCloseStatus(int code, @Nullable String reason) {
        this.code = code;
        if (reason != null && reason.length() > 0) {
            this.reason = reason;
        }
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public static Optional<WebSocketCloseStatus> valueOf(int code) {
        switch (code) {
            case -1: 
            case 1000: {
                return Optional.of(NORMAL);
            }
            case 1001: {
                return Optional.of(GOING_AWAY);
            }
            case 1002: {
                return Optional.of(PROTOCOL_ERROR);
            }
            case 1003: {
                return Optional.of(NOT_ACCEPTABLE);
            }
            case 1007: {
                return Optional.of(BAD_DATA);
            }
            case 1008: {
                return Optional.of(POLICY_VIOLATION);
            }
            case 1009: {
                return Optional.of(TOO_BIG_TO_PROCESS);
            }
            case 1010: {
                return Optional.of(REQUIRED_EXTENSION);
            }
            case 1011: {
                return Optional.of(SERVER_ERROR);
            }
            case 1012: {
                return Optional.of(SERVICE_RESTARTED);
            }
            case 1013: {
                return Optional.of(SERVICE_OVERLOAD);
            }
        }
        return Optional.empty();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.code);
        if (this.reason != null) {
            buff.append("(").append(this.reason).append(")");
        }
        return buff.toString();
    }
}

