/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.internal.unbescape.html.HtmlEscapeLevel;
import io.jooby.internal.unbescape.html.HtmlEscapeType;
import io.jooby.internal.unbescape.html.HtmlEscapeUtil;
import io.jooby.internal.unbescape.json.JsonEscapeLevel;
import io.jooby.internal.unbescape.json.JsonEscapeType;
import io.jooby.internal.unbescape.json.JsonEscapeUtil;
import io.jooby.internal.unbescape.uri.UriEscapeUtil;

public final class XSS {
    private XSS() {
    }

    @NonNull
    public static String uri(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return UriEscapeUtil.escape(value, UriEscapeUtil.UriEscapeType.PATH, "UTF-8");
    }

    @NonNull
    public static String html(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return HtmlEscapeUtil.escape(value, HtmlEscapeType.HTML5_NAMED_REFERENCES_DEFAULT_TO_DECIMAL, HtmlEscapeLevel.LEVEL_2_ALL_NON_ASCII_PLUS_MARKUP_SIGNIFICANT);
    }

    @NonNull
    public static String json(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return "\"\"";
        }
        return JsonEscapeUtil.escape(value, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_2_ALL_NON_ASCII_PLUS_BASIC_ESCAPE_SET);
    }
}

