/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.buffer;

import io.jooby.buffer.Assert;
import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferUtils;
import java.io.IOException;
import java.io.InputStream;

final class DataBufferInputStream
extends InputStream {
    private final DataBuffer dataBuffer;
    private final int end;
    private final boolean releaseOnClose;
    private boolean closed;
    private int mark;

    public DataBufferInputStream(DataBuffer dataBuffer, boolean releaseOnClose) {
        Assert.notNull(dataBuffer, "DataBuffer must not be null");
        this.dataBuffer = dataBuffer;
        int start = this.dataBuffer.readPosition();
        this.end = start + this.dataBuffer.readableByteCount();
        this.mark = start;
        this.releaseOnClose = releaseOnClose;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.available() == 0) {
            return -1;
        }
        return this.dataBuffer.read() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        len = Math.min(available, len);
        this.dataBuffer.read(b, off, len);
        return len;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        Assert.isTrue(readLimit > 0, "readLimit must be greater than 0");
        this.mark = this.dataBuffer.readPosition();
    }

    @Override
    public int available() {
        return Math.max(0, this.end - this.dataBuffer.readPosition());
    }

    @Override
    public void reset() {
        this.dataBuffer.readPosition(this.mark);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.releaseOnClose) {
            DataBufferUtils.release(this.dataBuffer);
        }
        this.closed = true;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("DataBufferInputStream is closed");
        }
    }
}

