/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.buffer;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.buffer.Assert;
import io.jooby.buffer.CloseableDataBuffer;
import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.buffer.OutputStreamPublisher;
import io.jooby.buffer.PooledDataBuffer;
import io.jooby.buffer.TouchableDataBuffer;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBufferUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataBufferUtils.class);
    private static final Consumer<DataBuffer> RELEASE_CONSUMER = DataBufferUtils::release;
    private static final int DEFAULT_CHUNK_SIZE = 1024;

    public static boolean release(@Nullable DataBuffer dataBuffer) {
        if (dataBuffer instanceof PooledDataBuffer) {
            PooledDataBuffer pooledDataBuffer = (PooledDataBuffer)dataBuffer;
            if (pooledDataBuffer.isAllocated()) {
                try {
                    return pooledDataBuffer.release();
                }
                catch (IllegalStateException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed to release PooledDataBuffer: " + String.valueOf(dataBuffer), ex);
                    }
                    return false;
                }
            }
        } else if (dataBuffer instanceof CloseableDataBuffer) {
            CloseableDataBuffer closeableDataBuffer = (CloseableDataBuffer)dataBuffer;
            try {
                closeableDataBuffer.close();
                return true;
            }
            catch (IllegalStateException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to release CloseableDataBuffer " + String.valueOf(dataBuffer), ex);
                }
                return false;
            }
        }
        return false;
    }

    public static <T extends DataBuffer> T retain(T dataBuffer) {
        if (dataBuffer instanceof PooledDataBuffer) {
            PooledDataBuffer pooledDataBuffer = (PooledDataBuffer)dataBuffer;
            return (T)pooledDataBuffer.retain();
        }
        return dataBuffer;
    }

    public static <T extends DataBuffer> T touch(T dataBuffer, Object hint) {
        if (dataBuffer instanceof TouchableDataBuffer) {
            TouchableDataBuffer touchableDataBuffer = (TouchableDataBuffer)dataBuffer;
            return (T)touchableDataBuffer.touch(hint);
        }
        return dataBuffer;
    }

    public static Flow.Publisher<DataBuffer> outputStreamPublisher(Consumer<OutputStream> outputStreamConsumer, DataBufferFactory bufferFactory, Executor executor) {
        return DataBufferUtils.outputStreamPublisher(outputStreamConsumer, bufferFactory, executor, 1024);
    }

    public static Flow.Publisher<DataBuffer> outputStreamPublisher(Consumer<OutputStream> outputStreamConsumer, DataBufferFactory bufferFactory, Executor executor, int chunkSize) {
        Assert.notNull(outputStreamConsumer, "OutputStreamConsumer must not be null");
        Assert.notNull(bufferFactory, "BufferFactory must not be null");
        Assert.notNull(executor, "Executor must not be null");
        Assert.isTrue(chunkSize > 0, "Chunk size must be > 0");
        return new OutputStreamPublisher(outputStreamConsumer, bufferFactory, executor, chunkSize);
    }

    public static Consumer<DataBuffer> releaseConsumer() {
        return RELEASE_CONSUMER;
    }
}

