/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.buffer;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.buffer.DataBuffer;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

class DataBufferWriter
extends Writer {
    private final DataBuffer dataBuffer;
    private final Charset charset;
    private boolean closed;

    public DataBufferWriter(DataBuffer dataBuffer, Charset charset) {
        this.dataBuffer = dataBuffer;
        this.charset = charset;
    }

    @Override
    public void write(int c) throws IOException {
        this.checkClosed();
        super.write(c);
    }

    @Override
    public void write(@NonNull char[] source) throws IOException {
        this.write(source, 0, source.length);
    }

    @Override
    public void write(@NonNull char[] source, int off, int len) throws IOException {
        this.checkClosed();
        this.dataBuffer.write(CharBuffer.wrap(source, off, len), this.charset);
    }

    @Override
    public void write(@NonNull String source) throws IOException {
        this.checkClosed();
        this.dataBuffer.write(CharBuffer.wrap(source), this.charset);
    }

    @Override
    public void write(@NonNull String source, int off, int len) throws IOException {
        this.checkClosed();
        this.dataBuffer.write(CharBuffer.wrap(source, off, off + len), this.charset);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("DataBufferWriter is closed");
        }
    }
}

