/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.buffer;

import io.jooby.buffer.Assert;
import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.buffer.DataBufferUtils;
import io.jooby.buffer.DefaultDataBuffer;
import java.nio.ByteBuffer;
import java.util.List;

public class DefaultDataBufferFactory
implements DataBufferFactory {
    public static final int DEFAULT_INITIAL_CAPACITY = 1024;
    public static final DefaultDataBufferFactory sharedInstance = new DefaultDataBufferFactory();
    private final boolean preferDirect;
    private int defaultInitialCapacity;

    public DefaultDataBufferFactory() {
        this(false);
    }

    public DefaultDataBufferFactory(boolean preferDirect) {
        this(preferDirect, 1024);
    }

    public DefaultDataBufferFactory(boolean preferDirect, int defaultInitialCapacity) {
        Assert.isTrue(defaultInitialCapacity > 0, "'defaultInitialCapacity' should be larger than 0");
        this.preferDirect = preferDirect;
        this.defaultInitialCapacity = defaultInitialCapacity;
    }

    @Override
    public int getDefaultInitialCapacity() {
        return this.defaultInitialCapacity;
    }

    @Override
    public DataBufferFactory setDefaultInitialCapacity(int defaultInitialCapacity) {
        this.defaultInitialCapacity = defaultInitialCapacity;
        return this;
    }

    @Override
    public DefaultDataBuffer allocateBuffer() {
        return this.allocateBuffer(this.defaultInitialCapacity);
    }

    @Override
    public DefaultDataBuffer allocateBuffer(int initialCapacity) {
        ByteBuffer byteBuffer = this.preferDirect ? ByteBuffer.allocateDirect(initialCapacity) : ByteBuffer.allocate(initialCapacity);
        return DefaultDataBuffer.fromEmptyByteBuffer(this, byteBuffer);
    }

    @Override
    public DefaultDataBuffer wrap(ByteBuffer byteBuffer) {
        return DefaultDataBuffer.fromFilledByteBuffer(this, byteBuffer.slice());
    }

    @Override
    public DefaultDataBuffer wrap(byte[] bytes) {
        return this.wrap(bytes, 0, bytes.length);
    }

    @Override
    public DefaultDataBuffer wrap(byte[] bytes, int offset, int length) {
        return DefaultDataBuffer.fromFilledByteBuffer(this, ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public DefaultDataBuffer join(List<? extends DataBuffer> dataBuffers) {
        Assert.notEmpty(dataBuffers, "DataBuffer List must not be empty");
        int capacity = dataBuffers.stream().mapToInt(DataBuffer::readableByteCount).sum();
        DefaultDataBuffer result = this.allocateBuffer(capacity);
        dataBuffers.forEach(xva$0 -> result.write((DataBuffer)xva$0));
        dataBuffers.forEach(DataBufferUtils::release);
        return result;
    }

    @Override
    public boolean isDirect() {
        return this.preferDirect;
    }

    public String toString() {
        return "DefaultDataBufferFactory (preferDirect=" + this.preferDirect + ")";
    }
}

