/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.exception;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.exception.BadRequestException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.StringJoiner;
import java.util.stream.Stream;

public class ProvisioningException
extends BadRequestException {
    public ProvisioningException(@NonNull Parameter parameter, @Nullable Throwable cause) {
        this("Unable to provision parameter: '" + ProvisioningException.toString(parameter) + "', require by: " + ProvisioningException.toString(parameter.getDeclaringExecutable()), cause);
    }

    public ProvisioningException(@NonNull String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    public static String toString(@NonNull Parameter parameter) {
        return parameter.getName() + ": " + String.valueOf(parameter.getParameterizedType());
    }

    public static String toString(@NonNull Executable method) {
        StringBuilder buff = new StringBuilder();
        if (method instanceof Constructor) {
            buff.append("constructor ");
            buff.append(method.getDeclaringClass().getCanonicalName());
        } else {
            buff.append("method ");
            buff.append(method.getDeclaringClass().getCanonicalName());
            buff.append(".");
            buff.append(method.getName());
        }
        buff.append("(");
        StringJoiner params = new StringJoiner(", ");
        Stream.of(method.getGenericParameterTypes()).forEach(type -> params.add(type.getTypeName()));
        buff.append(params);
        buff.append(")");
        return buff.toString();
    }
}

