/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.MediaType;
import io.jooby.SneakyThrows;
import io.jooby.internal.FileAsset;
import io.jooby.internal.JarAsset;
import io.jooby.internal.URLAsset;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;

public interface Asset
extends AutoCloseable {
    public static Asset create(@NonNull Path resource) {
        return new FileAsset(resource);
    }

    public static Asset create(@NonNull String path, @NonNull URL resource) {
        try {
            if ("jar".equals(resource.getProtocol())) {
                return new JarAsset((JarURLConnection)resource.openConnection());
            }
            if ("file".equals(resource.getProtocol())) {
                return Asset.create(Paths.get(resource.toURI()));
            }
            return new URLAsset(resource, path);
        }
        catch (IOException | URISyntaxException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    public long getSize();

    public long getLastModified();

    public boolean isDirectory();

    @NonNull
    default public String getEtag() {
        StringBuilder b = new StringBuilder(32);
        b.append("W/\"");
        Base64.Encoder encoder = Base64.getEncoder();
        int hashCode = this.hashCode();
        long lastModified = this.getLastModified();
        long length = this.getSize();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(lastModified ^ (long)hashCode);
        b.append(Long.toHexString(lastModified ^ (long)hashCode));
        buffer.clear();
        buffer.putLong(length ^ (long)hashCode);
        b.append(encoder.encodeToString(buffer.array()));
        b.append('\"');
        return b.toString();
    }

    @NonNull
    public MediaType getContentType();

    public InputStream stream();
}

