/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.Route;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.handler.Asset;
import io.jooby.handler.AssetSource;
import io.jooby.handler.CacheControl;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class AssetHandler
implements Route.Handler {
    private static final SneakyThrows.Consumer<Context> NOT_FOUND = ctx -> ctx.send(StatusCode.NOT_FOUND);
    private static final int ONE_SEC = 1000;
    private final AssetSource[] sources;
    private final CacheControl defaults = CacheControl.defaults();
    private String filekey;
    private String fallback;
    private Function<String, CacheControl> cacheControl = path -> this.defaults;
    private Function<Asset, MediaType> mediaTypeResolver = Asset::getContentType;
    private SneakyThrows.Consumer<Context> notFound = NOT_FOUND;

    public AssetHandler(@NonNull String fallback, AssetSource ... sources) {
        this.fallback = fallback;
        this.sources = AssetHandler.checkSource(sources);
    }

    public AssetHandler(AssetSource ... sources) {
        this.sources = AssetHandler.checkSource(sources);
    }

    @Override
    @NonNull
    public Object apply(@NonNull Context ctx) throws Exception {
        long lastModified;
        String resolvedPath;
        String filepath = ctx.path(this.filekey).value("index.html");
        Asset asset = this.resolve(filepath);
        if (asset == null) {
            if (this.fallback != null) {
                asset = this.resolve(this.fallback);
            }
            if (asset == null) {
                this.notFound.accept(ctx);
                return ctx;
            }
            resolvedPath = this.fallback;
        } else {
            resolvedPath = filepath;
        }
        CacheControl cacheParams = this.cacheControl.apply(resolvedPath);
        if (cacheParams.isEtag()) {
            String ifnm = ctx.header("If-None-Match").valueOrNull();
            if (ifnm != null && ifnm.equals(asset.getEtag())) {
                ctx.send(StatusCode.NOT_MODIFIED);
                asset.close();
                return ctx;
            }
            ctx.setResponseHeader("ETag", asset.getEtag());
        }
        if (cacheParams.isLastModified() && (lastModified = asset.getLastModified()) > 0L) {
            long ifms = ctx.header("If-Modified-Since").longValue(-1L);
            if (lastModified / 1000L <= ifms / 1000L) {
                ctx.send(StatusCode.NOT_MODIFIED);
                asset.close();
                return ctx;
            }
            ctx.setResponseHeader("Last-Modified", Instant.ofEpochMilli(lastModified));
        }
        if (cacheParams.getMaxAge() >= 0L) {
            ctx.setResponseHeader("Cache-Control", "max-age=" + cacheParams.getMaxAge());
        } else if (cacheParams.getMaxAge() == -2L) {
            ctx.setResponseHeader("Cache-Control", "no-store, must-revalidate");
        }
        long length = asset.getSize();
        if (length != -1L) {
            ctx.setResponseLength(length);
        }
        ctx.setResponseType(this.mediaTypeResolver.apply(asset));
        return ctx.send(asset.stream());
    }

    public AssetHandler setETag(boolean etag) {
        this.defaults.setETag(etag);
        return this;
    }

    public AssetHandler setMediaTypeResolver(Function<Asset, MediaType> mediaTypeResolver) {
        this.mediaTypeResolver = Objects.requireNonNull(mediaTypeResolver, "Media type resolver is required.");
        return this;
    }

    public AssetHandler setLastModified(boolean lastModified) {
        this.defaults.setLastModified(lastModified);
        return this;
    }

    public AssetHandler setMaxAge(long maxAge) {
        this.defaults.setMaxAge(maxAge);
        return this;
    }

    public AssetHandler setMaxAge(Duration maxAge) {
        this.defaults.setMaxAge(maxAge);
        return this;
    }

    public AssetHandler setNoCache() {
        this.defaults.setNoCache();
        return this;
    }

    public AssetHandler cacheControl(@NonNull Function<String, CacheControl> cacheControl) {
        this.cacheControl = Objects.requireNonNull(cacheControl);
        return this;
    }

    public AssetHandler notFound(@NonNull SneakyThrows.Consumer<Context> handler) {
        this.notFound = handler;
        return this;
    }

    @Nullable
    private Asset resolve(String filepath) {
        for (AssetSource source : this.sources) {
            Asset asset = source.resolve(filepath);
            if (asset == null) continue;
            return asset;
        }
        return null;
    }

    @Override
    public void setRoute(Route route) {
        List<String> keys2 = route.getPathKeys();
        this.filekey = keys2.isEmpty() ? route.getPattern().substring(1) : keys2.get(0);
        route.setReturnType((Type)((Object)Context.class));
    }

    private static AssetSource[] checkSource(AssetSource[] sources) {
        if (sources.length == 0) {
            throw new IllegalArgumentException("At least one source is required.");
        }
        return sources;
    }
}

