/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.SneakyThrows;
import io.jooby.handler.Asset;
import io.jooby.internal.ClassPathAssetSource;
import io.jooby.internal.FileDiskAssetSource;
import io.jooby.internal.FolderDiskAssetSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public interface AssetSource {
    @Nullable
    public Asset resolve(@NonNull String var1);

    @NonNull
    public static AssetSource create(@NonNull ClassLoader loader, @NonNull String location) {
        return new ClassPathAssetSource(loader, location);
    }

    @NonNull
    public static AssetSource webjars(@NonNull ClassLoader loader, @NonNull String name) {
        ClassPathAssetSource classPathAssetSource;
        block8: {
            List<String> location = Arrays.asList("META-INF/maven/org.webjars/" + name + "/pom.properties", "META-INF/maven/org.webjars.npm/" + name + "/pom.properties");
            String versionPath = location.stream().filter(it -> loader.getResource((String)it) != null).findFirst().orElseThrow(() -> SneakyThrows.propagate(new FileNotFoundException(location.toString())));
            InputStream in = loader.getResourceAsStream(versionPath);
            try {
                Properties properties = new Properties();
                properties.load(in);
                String version = properties.getProperty("version");
                String source = "/META-INF/resources/webjars/" + name + "/" + version;
                classPathAssetSource = new ClassPathAssetSource(loader, source);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException x) {
                    throw SneakyThrows.propagate(x);
                }
            }
            in.close();
        }
        return classPathAssetSource;
    }

    @NonNull
    public static AssetSource create(@NonNull Path location) {
        Path absoluteLocation = location.toAbsolutePath();
        if (Files.isDirectory(absoluteLocation, new LinkOption[0])) {
            return new FolderDiskAssetSource(absoluteLocation);
        }
        if (Files.isRegularFile(location, new LinkOption[0])) {
            return new FileDiskAssetSource(location);
        }
        throw SneakyThrows.propagate(new FileNotFoundException(location.toAbsolutePath().toString()));
    }
}

