/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.StatusCode;
import io.jooby.handler.Cors;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsHandler
implements Route.Filter {
    private static final String ORIGIN = "Origin";
    private static final String ANY_ORIGIN = "*";
    private static final String AC_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String AC_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String AC_MAX_AGE = "Access-Control-Max-Age";
    private static final String AC_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    private static final String AC_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String AC_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String AC_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String AC_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private final Cors options;
    private static final Logger log = LoggerFactory.getLogger(CorsHandler.class);

    public CorsHandler(@NonNull Cors options) {
        this.options = options;
    }

    public CorsHandler() {
        this(new Cors());
    }

    @Override
    @NonNull
    public Route.Handler apply(@NonNull Route.Handler next) {
        return ctx -> {
            String origin = ctx.header(ORIGIN).valueOrNull();
            if (origin != null) {
                if (!this.options.allowOrigin(origin)) {
                    log.debug("denied origin: {}", (Object)origin);
                    return ctx.send(StatusCode.FORBIDDEN);
                }
                log.debug("allowed origin: {}", (Object)origin);
                if (ctx.isPreflight()) {
                    log.debug("handling preflight for: {}", (Object)origin);
                    if (this.preflight(ctx, this.options, origin)) {
                        return ctx;
                    }
                    log.debug("preflight for {} {} with origin: {} failed", ctx.header(AC_REQUEST_METHOD), ctx.getRequestURL(), origin);
                    return ctx.send(StatusCode.FORBIDDEN);
                }
                if (this.handleNormalOptions(ctx)) {
                    return ctx;
                }
                log.debug("handling simple cors for: {}", (Object)origin);
                ctx.setResetHeadersOnError(false);
                CorsHandler.simple(ctx, this.options, origin);
            }
            return this.handleNormalOptions(ctx) ? ctx : next.apply(ctx);
        };
    }

    private boolean handleNormalOptions(Context ctx) {
        if (ctx.getMethod().equalsIgnoreCase("OPTIONS")) {
            log.debug("handling {} for: {}", (Object)ctx.getMethod(), (Object)ctx.getRequestPath());
            String allow = Router.METHODS.stream().flatMap(method -> this.allowMethod(ctx, (String)method)).collect(Collectors.joining(","));
            ctx.setResponseHeader("Allow", allow);
            ctx.send(StatusCode.OK);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<String> allowMethod(Context ctx, String method) {
        String existingMethod = ctx.getMethod();
        try {
            ctx.setMethod(method);
            Router.Match match = ctx.getRouter().match(ctx);
            Stream<String> stream = match.matches() ? Stream.of(method) : Stream.empty();
            return stream;
        }
        finally {
            ctx.setMethod(existingMethod);
        }
    }

    private static void simple(Context ctx, Cors options, String origin) {
        if ("null".equals(origin)) {
            ctx.setResponseHeader(AC_ALLOW_ORIGIN, ANY_ORIGIN);
        } else {
            ctx.setResponseHeader(AC_ALLOW_ORIGIN, origin);
            if (!options.anyHeader()) {
                ctx.setResponseHeader("Vary", ORIGIN);
            }
            if (options.getUseCredentials()) {
                ctx.setResponseHeader(AC_ALLOW_CREDENTIALS, true);
            }
            if (!options.getExposedHeaders().isEmpty()) {
                ctx.setResponseHeader(AC_EXPOSE_HEADERS, options.getExposedHeaders().stream().collect(Collectors.joining()));
            }
        }
    }

    @Override
    @NonNull
    public void setRoute(@NonNull Route route) {
        route.setHttpOptions(true);
    }

    private boolean preflight(Context ctx, Cors options, String origin) {
        long maxAge;
        boolean allowMethod = ctx.header(AC_REQUEST_METHOD).toOptional().map(options::allowMethod).orElse(false);
        if (!allowMethod) {
            return false;
        }
        List<String> headers = ctx.header(AC_REQUEST_HEADERS).toOptional().map(header -> Arrays.asList(header.split("\\s*,\\s*"))).orElse(Collections.emptyList());
        if (!options.allowHeaders(headers)) {
            return false;
        }
        ctx.setResponseHeader(AC_ALLOW_METHODS, options.getMethods().stream().collect(Collectors.joining(",")));
        List<String> allowedHeaders = options.anyHeader() ? headers : options.getHeaders();
        ctx.setResponseHeader(AC_ALLOW_HEADERS, allowedHeaders.stream().collect(Collectors.joining(",")));
        if (options.getUseCredentials()) {
            ctx.setResponseHeader(AC_ALLOW_CREDENTIALS, true);
        }
        if ((maxAge = options.getMaxAge().getSeconds()) > 0L) {
            ctx.setResponseHeader(AC_MAX_AGE, maxAge);
        }
        ctx.setResponseHeader(AC_ALLOW_ORIGIN, origin);
        if (!options.anyOrigin()) {
            ctx.setResponseHeader("Vary", ORIGIN);
        }
        ctx.send(StatusCode.OK);
        return true;
    }
}

