/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Route;
import io.jooby.Session;
import io.jooby.exception.InvalidCsrfToken;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class CsrfHandler
implements Route.Before {
    public static final Predicate<Context> DEFAULT_FILTER = ctx -> "POST".equals(ctx.getMethod()) || "DELETE".equals(ctx.getMethod()) || "PATCH".equals(ctx.getMethod()) || "PUT".equals(ctx.getMethod());
    public static final Function<Context, String> DEFAULT_GENERATOR = ctx -> UUID.randomUUID().toString();
    private String name;
    private Function<Context, String> generator = DEFAULT_GENERATOR;
    private Predicate<Context> filter = DEFAULT_FILTER;

    public CsrfHandler(String name) {
        this.name = name;
    }

    public CsrfHandler() {
        this("csrf");
    }

    @Override
    public void apply(@NonNull Context ctx) throws Exception {
        String clientToken;
        Session session = ctx.session();
        String token = session.get(this.name).toOptional().orElseGet(() -> {
            String newToken = this.generator.apply(ctx);
            session.put(this.name, newToken);
            return newToken;
        });
        ctx.setAttribute(this.name, token);
        if (this.filter.test(ctx) && !token.equals(clientToken = (String)Stream.of(ctx.header(this.name).valueOrNull(), ctx.cookie(this.name).valueOrNull(), ctx.form(this.name).valueOrNull(), ctx.query(this.name).valueOrNull()).filter(Objects::nonNull).findFirst().orElse(null))) {
            throw new InvalidCsrfToken(clientToken);
        }
    }

    @NonNull
    public CsrfHandler setTokenGenerator(@NonNull Function<Context, String> generator) {
        this.generator = generator;
        return this;
    }

    @NonNull
    public CsrfHandler setRequestFilter(@NonNull Predicate<Context> filter) {
        this.filter = filter;
        return this;
    }
}

