/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.ConsumptionProbe;
import io.jooby.Context;
import io.jooby.Route;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class RateLimitHandler
implements Route.Before {
    private final Function<Context, Bucket> factory;

    public RateLimitHandler(@NonNull SneakyThrows.Function<String, Bucket> bucketFactory) {
        this(bucketFactory, Context::getRemoteAddress);
    }

    public RateLimitHandler(@NonNull SneakyThrows.Function<String, Bucket> bucketFactory, @NonNull String headerName) {
        this(bucketFactory, (Context ctx) -> ctx.header(headerName).value());
    }

    public RateLimitHandler(@NonNull SneakyThrows.Function<String, Bucket> bucketFactory, @NonNull SneakyThrows.Function<Context, String> classifier) {
        this(RateLimitHandler.byKey(bucketFactory, classifier));
    }

    public RateLimitHandler(@NonNull Bucket bucket) {
        this((Context ctx) -> bucket);
    }

    private RateLimitHandler(Function<Context, Bucket> factory) {
        this.factory = factory;
    }

    @NonNull
    public static RateLimitHandler cluster(@NonNull SneakyThrows.Function<String, Bucket> proxyManager) {
        return RateLimitHandler.cluster(proxyManager, Context::getRemoteAddress);
    }

    @NonNull
    public static RateLimitHandler cluster(@NonNull SneakyThrows.Function<String, Bucket> proxyManager, @NonNull String headerName) {
        return RateLimitHandler.cluster(proxyManager, (Context ctx) -> ctx.header(headerName).value());
    }

    public static RateLimitHandler cluster(@NonNull SneakyThrows.Function<String, Bucket> proxyManager, @NonNull SneakyThrows.Function<Context, String> classifier) {
        return new RateLimitHandler(ctx -> (Bucket)proxyManager.apply((String)classifier.apply((Context)ctx)));
    }

    @Override
    public void apply(@NonNull Context ctx) throws Exception {
        Bucket bucket = this.factory.apply(ctx);
        ConsumptionProbe probe = bucket.tryConsumeAndReturnRemaining(1L);
        if (probe.isConsumed()) {
            ctx.setResponseHeader("X-Rate-Limit-Remaining", probe.getRemainingTokens());
        } else {
            ctx.setResponseHeader("X-Rate-Limit-Retry-After-Milliseconds", TimeUnit.NANOSECONDS.toMillis(probe.getNanosToWaitForRefill()));
            ctx.send(StatusCode.TOO_MANY_REQUESTS);
        }
    }

    private static Function<Context, Bucket> byKey(SneakyThrows.Function<String, Bucket> bucketFactory, SneakyThrows.Function<Context, String> classifier) {
        ConcurrentHashMap buckets = new ConcurrentHashMap();
        return ctx -> (Bucket)buckets.computeIfAbsent((String)classifier.apply((Context)ctx), bucketFactory);
    }
}

