/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Route;

public class SSLHandler
implements Route.Before {
    private static final int SECURE_PORT = 443;
    private final String host;
    private final int port;

    public SSLHandler(@NonNull String host, int port) {
        this.host = host;
        this.port = port;
    }

    public SSLHandler(@NonNull String host) {
        this(host, 443);
    }

    public SSLHandler(int port) {
        this.host = null;
        this.port = port;
    }

    public SSLHandler() {
        this(443);
    }

    @Override
    public void apply(@NonNull Context ctx) {
        if (!ctx.isSecure()) {
            String hostAndPort;
            int i;
            String host = this.host == null ? ((i = (hostAndPort = ctx.getHostAndPort()).lastIndexOf(58)) > 0 ? hostAndPort.substring(0, i) : hostAndPort) : this.host;
            StringBuilder buff = new StringBuilder("https://");
            buff.append(host);
            if (host.equals("localhost")) {
                int securePort = ctx.getRouter().getServerOptions().getSecurePort();
                buff.append(":").append(securePort);
            } else if (this.port > 0 && this.port != 443) {
                buff.append(":").append(this.port);
            }
            buff.append(ctx.getRequestPath());
            buff.append(ctx.queryString());
            ctx.sendRedirect(buff.toString());
        }
    }
}

