/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Route;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TraceHandler
implements Route.Filter {
    private static final String CRLF = "\r\n";

    @Override
    @NonNull
    public Route.Handler apply(@NonNull Route.Handler next) {
        return ctx -> {
            if (ctx.getMethod().equals("TRACE")) {
                StringBuilder buffer = new StringBuilder("TRACE").append(" ").append(ctx.getRequestPath()).append(" ").append(ctx.getProtocol());
                for (Map.Entry<String, List<String>> entry : ctx.header().toMultimap().entrySet()) {
                    buffer.append(CRLF).append(entry.getKey()).append(": ").append(entry.getValue().stream().collect(Collectors.joining(", ")));
                }
                buffer.append(CRLF);
                ctx.setResponseType("message/http");
                return ctx.send(buffer.toString());
            }
            return next.apply(ctx);
        };
    }

    @Override
    @NonNull
    public void setRoute(@NonNull Route route) {
        route.setHttpTrace(true);
    }
}

