/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.ValueNode;
import io.jooby.internal.MissingValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ByteArrayBody
implements Body {
    private static final byte[] EMPTY = new byte[0];
    protected final Context ctx;
    private final byte[] bytes;

    public ByteArrayBody(Context ctx, byte[] bytes) {
        this.ctx = ctx;
        this.bytes = bytes;
    }

    @Override
    public long getSize() {
        return this.bytes.length;
    }

    @Override
    @NonNull
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    @NonNull
    public ReadableByteChannel channel() {
        return Channels.newChannel(this.stream());
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    @NonNull
    public InputStream stream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    @NonNull
    public String value() {
        return this.value(StandardCharsets.UTF_8);
    }

    @Override
    @NonNull
    public List<String> toList() {
        return Collections.singletonList(this.value());
    }

    @Override
    @NonNull
    public ValueNode get(int index) {
        return index == 0 ? this : this.get(Integer.toString(index));
    }

    @Override
    @NonNull
    public ValueNode get(@NonNull String name) {
        return new MissingValue(name);
    }

    @Override
    public String name() {
        return "body";
    }

    @Override
    @NonNull
    public <T> T to(@NonNull Type type) {
        return this.ctx.decode(type, this.ctx.getRequestType(MediaType.text));
    }

    @Override
    @Nullable
    public <T> T toNullable(@NonNull Type type) {
        return this.bytes.length == 0 ? null : (T)this.ctx.decode(type, this.ctx.getRequestType(MediaType.text));
    }

    @Override
    @NonNull
    public Map<String, List<String>> toMultimap() {
        return Map.of();
    }

    public static Body empty(Context ctx) {
        return new ByteArrayBody(ctx, EMPTY);
    }
}

