/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.MessageEncoder;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.internal.RouteTree;
import io.jooby.internal.RouterMatch;
import io.jooby.internal.StaticRouterMatch;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Chi
implements RouteTree {
    private static final String EMPTY_STRING = "";
    private static final Slice EMPTY_SLICE = new Slice("");
    private static final byte ntStatic = 0;
    private static final byte ntRegexp = 1;
    private static final byte ntParam = 2;
    private static final byte ntCatchAll = 3;
    private static final int NODE_SIZE = 4;
    static final char ZERO_CHAR = '\u0000';
    private MessageEncoder encoder;
    private static final String BASE_CATCH_ALL = "/?*";
    private final Node root = new Node();
    private StaticMap staticPaths = StaticMap.INIT;

    Chi() {
    }

    @Override
    public void insert(String method, String pattern, Route route) {
        String baseCatchAll = this.baseCatchAll((String)pattern);
        if (baseCatchAll.length() > 1) {
            this.insert(method, baseCatchAll, route);
            String tail = ((String)pattern).substring(baseCatchAll.length() + 2);
            pattern = baseCatchAll + "/" + tail;
        }
        if (((String)pattern).equals(BASE_CATCH_ALL)) {
            pattern = "/*";
        }
        if (Router.pathKeys((String)pattern).isEmpty()) {
            StaticRoute staticRoute = new StaticRoute();
            this.staticPaths = this.staticPaths.put((String)pattern, staticRoute);
            staticRoute.put(method, route);
        }
        this.root.insertRoute(method, (String)pattern, route);
    }

    private String baseCatchAll(String pattern) {
        int i = pattern.indexOf(BASE_CATCH_ALL);
        if (i > 0) {
            return pattern.substring(0, i);
        }
        return EMPTY_STRING;
    }

    public void insert(Route route) {
        this.insert(route.getMethod(), route.getPattern(), route);
    }

    @Override
    public void destroy() {
        this.root.destroy();
    }

    @Override
    public boolean exists(String method, String path) {
        return this.find(method, path).matches();
    }

    @Override
    public Router.Match find(String method, String path) {
        StaticRoute staticRoute = this.staticPaths.get(path);
        if (staticRoute == null) {
            return this.findInternal(method, path);
        }
        StaticRouterMatch match = staticRoute.matcher.get(method);
        return match == null ? this.findInternal(method, path) : match;
    }

    private Router.Match findInternal(String method, String path) {
        RouterMatch result = new RouterMatch();
        Route route = this.root.findRoute(result, method, new Slice(path));
        if (route == null) {
            return result.missing(method, path, this.encoder);
        }
        return result.found(route);
    }

    public void setEncoder(MessageEncoder encoder) {
        this.encoder = encoder;
    }

    private static class Node
    implements Comparable<Node> {
        byte typ;
        char label;
        char tail;
        String prefix;
        Pattern rex;
        Map<String, Route> endpoints;
        Node[][] children = new Node[4][];

        private Node() {
        }

        public Node typ(byte typ) {
            this.typ = typ;
            return this;
        }

        @Override
        public int compareTo(Node o) {
            return this.label - o.label;
        }

        public Node label(char label) {
            this.label = label;
            return this;
        }

        public Node tail(char tail) {
            this.tail = tail;
            return this;
        }

        public Node prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public String toString() {
            StringBuilder node = new StringBuilder();
            if (this.prefix != null) {
                node.append(this.prefix);
            }
            node.append("{type: ");
            switch (this.typ) {
                case 0: {
                    node.append("static");
                    break;
                }
                case 2: {
                    node.append("param");
                    break;
                }
                case 1: {
                    node.append("regex");
                    break;
                }
                default: {
                    node.append("catch-all");
                }
            }
            String nodes = Stream.of(this.children).filter(Objects::nonNull).flatMap(Stream::of).filter(Objects::nonNull).map(Node::toString).collect(Collectors.joining(", ", "[", "]"));
            node.append(", children: ").append(nodes);
            node.append("}");
            return node.toString();
        }

        Node insertRoute(String method, String pattern, Route route) {
            int commonPrefix;
            Node parent;
            Segment seg;
            Node n = this;
            String search = pattern;
            while (true) {
                if (search.length() == 0) {
                    n.setEndpoint(method, route);
                    return n;
                }
                char label = search.charAt(0);
                seg = label == '{' || label == '*' ? this.patNextSegment(search) : new Segment();
                String prefix = seg.nodeType == 1 ? seg.rexPat : Chi.EMPTY_STRING;
                parent = n;
                if ((n = n.getEdge(seg.nodeType, label, seg.tail, prefix)) == null) {
                    Node child = new Node().label(label).tail(seg.tail).prefix(search);
                    Node hn = parent.addChild(child, search);
                    hn.setEndpoint(method, route);
                    return hn;
                }
                if (n.typ > 0) {
                    search = search.substring(seg.endIndex);
                    continue;
                }
                commonPrefix = this.longestPrefix(search, n.prefix);
                if (commonPrefix != n.prefix.length()) break;
                search = search.substring(commonPrefix);
            }
            Node child = new Node().typ((byte)0).prefix(search.substring(0, commonPrefix));
            parent.replaceChild(search.charAt(0), seg.tail, child);
            n.label = n.prefix.charAt(commonPrefix);
            n.prefix = n.prefix.substring(commonPrefix);
            child.addChild(n, n.prefix);
            search = search.substring(commonPrefix);
            if (search.length() == 0) {
                child.setEndpoint(method, route);
                return child;
            }
            Node subchild = new Node().typ((byte)0).label(search.charAt(0)).prefix(search);
            Node hn = child.addChild(subchild, search);
            hn.setEndpoint(method, route);
            return hn;
        }

        Node addChild(Node child, String search) {
            Node n = this;
            Node hn = child;
            Segment seg = this.patNextSegment(search);
            byte segTyp = seg.nodeType;
            int segStartIdx = seg.startIndex;
            int segEndIdx = seg.endIndex;
            switch (segTyp) {
                case 0: {
                    break;
                }
                default: {
                    if (segTyp == 1) {
                        child.prefix = seg.rexPat;
                        child.rex = Pattern.compile(seg.rexPat);
                    }
                    if (segStartIdx == 0) {
                        child.typ = segTyp;
                        segStartIdx = segTyp == 3 ? -1 : segEndIdx;
                        if (segStartIdx < 0) {
                            segStartIdx = search.length();
                        }
                        child.tail = seg.tail;
                        if (segStartIdx == search.length()) break;
                        search = search.substring(segStartIdx);
                        Node nn = new Node().typ((byte)0).label(search.charAt(0)).prefix(search);
                        hn = child.addChild(nn, search);
                        break;
                    }
                    if (segStartIdx <= 0) break;
                    child.typ = 0;
                    child.prefix = search.substring(0, segStartIdx);
                    child.rex = null;
                    search = search.substring(segStartIdx);
                    Node nn = new Node().typ(segTyp).label(search.charAt(0)).tail(seg.tail);
                    hn = child.addChild(nn, search);
                }
            }
            n.children[child.typ] = this.append(n.children[child.typ], child);
            this.tailSort(n.children[child.typ]);
            return hn;
        }

        void replaceChild(char label, char tail, Node child) {
            Node n = this;
            Node[] children = n.children[child.typ];
            for (int i = 0; children != null && i < children.length; ++i) {
                if (children[i].label != label || children[i].tail != tail) continue;
                children[i] = child;
                children[i].label = label;
                children[i].tail = tail;
                return;
            }
            throw new IllegalArgumentException("chi: replacing missing child");
        }

        Node getEdge(int ntyp, char label, char tail, String prefix) {
            Node n = this;
            Node[] nds = n.children[ntyp];
            for (int i = 0; nds != null && i < nds.length; ++i) {
                if (nds[i].label != label || nds[i].tail != tail || ntyp == 1 && !nds[i].prefix.equals(prefix)) continue;
                return nds[i];
            }
            return null;
        }

        void setEndpoint(String method, Route route) {
            Node n = this;
            if (n.endpoints == null) {
                n.endpoints = new ConcurrentHashMap<String, Route>();
            }
            n.endpoints.put(method, route);
        }

        Route findRoute(RouterMatch rctx, String method, Slice path) {
            block4: for (int ntyp = 0; ntyp < 4; ++ntyp) {
                Route fin;
                Node[] nds = this.children[ntyp];
                if (nds == null) continue;
                Node xn = null;
                Slice xsearch = path;
                char label = xsearch.isEmpty() ? (char)'\u0000' : xsearch.charAt(0);
                switch (ntyp) {
                    case 0: {
                        xn = this.findEdge(nds, label);
                        if (xn == null || !xsearch.startsWith(xn.prefix)) continue block4;
                        xsearch = xsearch.substring(xn.prefix.length());
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (xsearch.length() == 0) continue block4;
                        for (int idx = 0; idx < nds.length; ++idx) {
                            Route fin2;
                            xn = nds[idx];
                            int p = xsearch.indexOf(xn.tail);
                            if (p < 0) {
                                if (xn.tail != '/') continue;
                                p = xsearch.length();
                            }
                            if (ntyp == 1 && xn.rex != null ? !xn.rex.matcher(xsearch.substring(0, p)).matches() : xsearch.substring(0, p).indexOf(47) > 0) continue;
                            int prevlen = rctx.vars.size();
                            rctx.value(xsearch.substring(0, p).toString());
                            xsearch = xsearch.substring(p);
                            if (xsearch.length() == 0 && xn.isLeaf()) {
                                Route h = xn.endpoints.get(method);
                                if (h != null) {
                                    rctx.key(h.getPathKeys());
                                    return h;
                                }
                                rctx.methodNotAllowed(xn.endpoints.keySet());
                            }
                            if ((fin2 = xn.findRoute(rctx, method, xsearch)) != null) {
                                return fin2;
                            }
                            rctx.truncate(prevlen);
                            xsearch = path;
                        }
                        break;
                    }
                    default: {
                        if (xsearch.length() > 0) {
                            rctx.value(xsearch.toString());
                        }
                        xn = nds[0];
                        xsearch = EMPTY_SLICE;
                    }
                }
                if (xn == null) continue;
                if (xsearch.length() == 0 && xn.isLeaf()) {
                    Route h = xn.endpoints.get(method);
                    if (h != null) {
                        rctx.key(h.getPathKeys());
                        return h;
                    }
                    rctx.methodNotAllowed(xn.endpoints.keySet());
                }
                if ((fin = xn.findRoute(rctx, method, xsearch)) != null) {
                    return fin;
                }
                if (xn.typ <= 0) continue;
                rctx.pop();
            }
            return null;
        }

        Node findEdge(Node[] ns, char label) {
            int num = ns.length;
            int idx = 0;
            int i = 0;
            int j = num - 1;
            while (i <= j) {
                idx = i + (j - i) / 2;
                if (label > ns[idx].label) {
                    i = idx + 1;
                    continue;
                }
                if (label < ns[idx].label) {
                    j = idx - 1;
                    continue;
                }
                i = num;
            }
            if (ns[idx].label != label) {
                return null;
            }
            return ns[idx];
        }

        boolean isLeaf() {
            return this.endpoints != null;
        }

        int longestPrefix(String k1, String k2) {
            int len = Math.min(k1.length(), k2.length());
            for (int i = 0; i < len; ++i) {
                if (k1.charAt(i) == k2.charAt(i)) continue;
                return i;
            }
            return len;
        }

        void tailSort(Node[] ns) {
            if (ns != null && ns.length > 1) {
                Arrays.sort(ns);
                for (int i = ns.length - 1; i >= 0; --i) {
                    if (ns[i].typ <= 0 || ns[i].tail != '/') continue;
                    Node tmp = ns[i];
                    ns[i] = ns[ns.length - 1];
                    ns[ns.length - 1] = tmp;
                    return;
                }
            }
        }

        private Node[] append(Node[] src, Node child) {
            if (src == null) {
                return new Node[]{child};
            }
            Node[] result = new Node[src.length + 1];
            System.arraycopy(src, 0, result, 0, src.length);
            result[result.length - 1] = child;
            return result;
        }

        Segment patNextSegment(String pattern) {
            int ps = pattern.indexOf(123);
            int ws = pattern.indexOf(42);
            if (ps < 0 && ws < 0) {
                return new Segment(0, Chi.EMPTY_STRING, '\u0000', 0, pattern.length());
            }
            if (ws >= 0 && ws < ps) {
                throw new IllegalArgumentException("chi: wildcard '*' must be the last pattern in a route, otherwise use a '{param}'");
            }
            char tail = '/';
            if (ps >= 0) {
                byte nt = 2;
                int cc = 0;
                int pe = ps;
                String range = pattern.substring(ps);
                for (int i = 0; i < range.length(); ++i) {
                    char c = range.charAt(i);
                    if (c == '{') {
                        ++cc;
                        continue;
                    }
                    if (c != '}' || --cc != 0) continue;
                    pe = ps + i;
                    break;
                }
                if (pe == ps) {
                    throw new IllegalArgumentException("Router: route param closing delimiter '}' is missing");
                }
                String key = pattern.substring(ps + 1, pe);
                if (++pe < pattern.length()) {
                    tail = pattern.charAt(pe);
                }
                Object rexpat = Chi.EMPTY_STRING;
                int idx = key.indexOf(58);
                if (idx >= 0) {
                    nt = 1;
                    rexpat = key.substring(idx + 1);
                }
                if (((String)rexpat).length() > 0) {
                    if (((String)rexpat).charAt(0) != '^') {
                        rexpat = "^" + (String)rexpat;
                    }
                    if (((String)rexpat).charAt(((String)rexpat).length() - 1) != '$') {
                        rexpat = (String)rexpat + "$";
                    }
                }
                return new Segment(nt, (String)rexpat, tail, ps, pe);
            }
            return new Segment(3, Chi.EMPTY_STRING, '\u0000', ws, pattern.length());
        }

        public void destroy() {
            for (int ntyp = 0; ntyp < this.children.length; ++ntyp) {
                Node[] nds = this.children[ntyp];
                if (nds == null) continue;
                for (int i = 0; i < nds.length; ++i) {
                    nds[i].destroy();
                    nds[i] = null;
                }
                this.children[ntyp] = null;
            }
            this.children = null;
            if (this.endpoints != null) {
                this.endpoints.clear();
                this.endpoints = null;
            }
        }
    }

    private static interface StaticMap {
        public static final StaticMap INIT = new StaticMap(){

            @Override
            public StaticRoute get(String path) {
                return null;
            }

            @Override
            public StaticMap put(String path, StaticRoute staticRoute) {
                return new StaticMap1(path, staticRoute);
            }
        };

        public StaticRoute get(String var1);

        public StaticMap put(String var1, StaticRoute var2);
    }

    static class StaticRoute {
        private MethodMatcher matcher;

        StaticRoute() {
        }

        public void put(String method, Route route) {
            if (this.matcher == null) {
                this.matcher = new SingleMethodMatcher();
            } else if (this.matcher instanceof SingleMethodMatcher) {
                this.matcher = new MultipleMethodMatcher((SingleMethodMatcher)this.matcher);
            }
            this.matcher.put(method, new StaticRouterMatch(route));
        }
    }

    private static interface MethodMatcher {
        public StaticRouterMatch get(String var1);

        public void put(String var1, StaticRouterMatch var2);

        public boolean matches(String var1);
    }

    private static class Slice
    implements CharSequence {
        private final String base;
        private final int startIndex;
        private final int endIndex;

        public Slice(String base, int startIndex, int endIndex) {
            this.base = base;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public Slice(String base, int startIndex) {
            this(base, startIndex, base.length());
        }

        public Slice(String base) {
            this(base, 0);
        }

        @Override
        public int length() {
            return this.endIndex - this.startIndex;
        }

        @Override
        public char charAt(int index) {
            return this.base.charAt(this.startIndex + index);
        }

        @Override
        public Slice subSequence(int start, int end) {
            return new Slice(this.base, this.startIndex + start, this.startIndex + end);
        }

        @Override
        public String toString() {
            return this.base.substring(this.startIndex, this.endIndex);
        }

        public Slice substring(int start) {
            return this.substring(start, this.length());
        }

        public Slice substring(int start, int end) {
            return this.subSequence(start, end);
        }

        public int indexOf(int ch) {
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                if (this.base.charAt(i) != ch) continue;
                return i - this.startIndex;
            }
            return -1;
        }

        public boolean startsWith(String prefix) {
            int len = prefix.length();
            if (len <= this.length()) {
                for (int i = 0; i < len; ++i) {
                    if (this.base.charAt(i + this.startIndex) == prefix.charAt(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    static class Segment {
        byte nodeType;
        String rexPat = "";
        char tail;
        int startIndex;
        int endIndex;

        public Segment() {
        }

        public Segment(byte nodeType, String regex, char tail, int startIndex, int endIndex) {
            this.nodeType = nodeType;
            this.rexPat = regex;
            this.tail = tail;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }

    private static class MultipleMethodMatcher
    implements MethodMatcher {
        private Map<String, StaticRouterMatch> methods = new ConcurrentHashMap<String, StaticRouterMatch>();

        public MultipleMethodMatcher(SingleMethodMatcher matcher) {
            this.methods.put(matcher.method, matcher.route);
            matcher.clear();
        }

        @Override
        public StaticRouterMatch get(String method) {
            return this.methods.get(method);
        }

        @Override
        public void put(String method, StaticRouterMatch route) {
            this.methods.put(method, route);
        }

        @Override
        public boolean matches(String method) {
            return this.methods.containsKey(method);
        }
    }

    private static class SingleMethodMatcher
    implements MethodMatcher {
        private String method;
        private StaticRouterMatch route;

        private SingleMethodMatcher() {
        }

        @Override
        public void put(String method, StaticRouterMatch route) {
            this.method = method;
            this.route = route;
        }

        @Override
        public StaticRouterMatch get(String method) {
            if (this.method == method) {
                return this.route;
            }
            return this.method.equals(method) ? this.route : null;
        }

        @Override
        public boolean matches(String method) {
            return this.method.equals(method);
        }

        public void clear() {
            this.method = null;
            this.route = null;
        }
    }

    private static class StaticMapN
    implements StaticMap {
        private final Map<String, StaticRoute> paths = new ConcurrentHashMap<String, StaticRoute>(10);

        public StaticMapN(StaticMap6 staticMap, String path, StaticRoute staticRoute) {
            this.put(staticMap.pattern1, staticMap.route1);
            this.put(staticMap.pattern2, staticMap.route2);
            this.put(staticMap.pattern3, staticMap.route3);
            this.put(staticMap.pattern4, staticMap.route4);
            this.put(staticMap.pattern5, staticMap.route5);
            this.put(staticMap.pattern6, staticMap.route6);
            this.put(path, staticRoute);
            staticMap.release();
        }

        @Override
        public StaticRoute get(String path) {
            return this.paths.get(path);
        }

        @Override
        public StaticMap put(String path, StaticRoute staticRoute) {
            this.paths.computeIfAbsent(path, k -> staticRoute);
            return this;
        }
    }

    private static class StaticMap6
    implements StaticMap {
        private String pattern1;
        private StaticRoute route1;
        private String pattern2;
        private StaticRoute route2;
        private String pattern3;
        private StaticRoute route3;
        private String pattern4;
        private StaticRoute route4;
        private String pattern5;
        private StaticRoute route5;
        private String pattern6;
        private StaticRoute route6;

        public StaticMap6(StaticMap5 staticMap, String path, StaticRoute route) {
            this.pattern1 = staticMap.pattern1;
            this.route1 = staticMap.route1;
            this.pattern2 = staticMap.pattern2;
            this.route2 = staticMap.route2;
            this.pattern3 = staticMap.pattern3;
            this.route3 = staticMap.route3;
            this.pattern4 = staticMap.pattern4;
            this.route4 = staticMap.route4;
            this.pattern5 = staticMap.pattern5;
            this.route5 = staticMap.route5;
            this.pattern6 = path;
            this.route6 = route;
            staticMap.release();
        }

        public void release() {
            this.pattern1 = null;
            this.route1 = null;
            this.pattern2 = null;
            this.route2 = null;
            this.pattern3 = null;
            this.route3 = null;
            this.pattern4 = null;
            this.route4 = null;
            this.pattern5 = null;
            this.route5 = null;
            this.pattern6 = null;
            this.route6 = null;
        }

        @Override
        public StaticMap put(String path, StaticRoute route) {
            if (this.pattern1.equals(path)) {
                this.route1 = route;
                return this;
            }
            if (this.pattern2.equals(path)) {
                this.route2 = route;
                return this;
            }
            if (this.pattern3.equals(path)) {
                this.route3 = route;
                return this;
            }
            if (this.pattern4.equals(path)) {
                this.route4 = route;
                return this;
            }
            if (this.pattern5.equals(path)) {
                this.route5 = route;
                return this;
            }
            if (this.pattern6.equals(path)) {
                this.route6 = route;
            }
            return new StaticMapN(this, path, route);
        }

        @Override
        public StaticRoute get(String path) {
            if (this.pattern1.equals(path)) {
                return this.route1;
            }
            if (this.pattern2.equals(path)) {
                return this.route2;
            }
            if (this.pattern3.equals(path)) {
                return this.route3;
            }
            if (this.pattern4.equals(path)) {
                return this.route4;
            }
            if (this.pattern5.equals(path)) {
                return this.route5;
            }
            if (this.pattern6.equals(path)) {
                return this.route6;
            }
            return null;
        }
    }

    private static class StaticMap5
    implements StaticMap {
        private String pattern1;
        private StaticRoute route1;
        private String pattern2;
        private StaticRoute route2;
        private String pattern3;
        private StaticRoute route3;
        private String pattern4;
        private StaticRoute route4;
        private String pattern5;
        private StaticRoute route5;

        public StaticMap5(StaticMap4 staticMap, String path, StaticRoute route) {
            this.pattern1 = staticMap.pattern1;
            this.route1 = staticMap.route1;
            this.pattern2 = staticMap.pattern2;
            this.route2 = staticMap.route2;
            this.pattern3 = staticMap.pattern3;
            this.route3 = staticMap.route3;
            this.pattern4 = staticMap.pattern4;
            this.route4 = staticMap.route4;
            this.pattern5 = path;
            this.route5 = route;
            staticMap.release();
        }

        public void release() {
            this.pattern1 = null;
            this.route1 = null;
            this.pattern2 = null;
            this.route2 = null;
            this.pattern3 = null;
            this.route3 = null;
            this.pattern4 = null;
            this.route4 = null;
            this.pattern5 = null;
            this.route5 = null;
        }

        @Override
        public StaticMap put(String path, StaticRoute route) {
            if (this.pattern1.equals(path)) {
                this.route1 = route;
                return this;
            }
            if (this.pattern2.equals(path)) {
                this.route2 = route;
                return this;
            }
            if (this.pattern3.equals(path)) {
                this.route3 = route;
                return this;
            }
            if (this.pattern4.equals(path)) {
                this.route4 = route;
                return this;
            }
            if (this.pattern5.equals(path)) {
                this.route5 = route;
                return this;
            }
            return new StaticMap6(this, path, route);
        }

        @Override
        public StaticRoute get(String path) {
            if (this.pattern1.equals(path)) {
                return this.route1;
            }
            if (this.pattern2.equals(path)) {
                return this.route2;
            }
            if (this.pattern3.equals(path)) {
                return this.route3;
            }
            if (this.pattern4.equals(path)) {
                return this.route4;
            }
            if (this.pattern5.equals(path)) {
                return this.route5;
            }
            return null;
        }
    }

    private static class StaticMap4
    implements StaticMap {
        private String pattern1;
        private StaticRoute route1;
        private String pattern2;
        private StaticRoute route2;
        private String pattern3;
        private StaticRoute route3;
        private String pattern4;
        private StaticRoute route4;

        public StaticMap4(StaticMap3 staticMap, String path, StaticRoute route) {
            this.pattern1 = staticMap.pattern1;
            this.route1 = staticMap.route1;
            this.pattern2 = staticMap.pattern2;
            this.route2 = staticMap.route2;
            this.pattern3 = staticMap.pattern3;
            this.route3 = staticMap.route3;
            this.pattern4 = path;
            this.route4 = route;
            staticMap.release();
        }

        public void release() {
            this.pattern1 = null;
            this.route1 = null;
            this.pattern2 = null;
            this.route2 = null;
            this.pattern3 = null;
            this.route3 = null;
            this.pattern4 = null;
            this.route4 = null;
        }

        @Override
        public StaticMap put(String path, StaticRoute route) {
            if (this.pattern1.equals(path)) {
                this.route1 = route;
                return this;
            }
            if (this.pattern2.equals(path)) {
                this.route2 = route;
                return this;
            }
            if (this.pattern3.equals(path)) {
                this.route3 = route;
                return this;
            }
            if (this.pattern4.equals(path)) {
                this.route4 = route;
                return this;
            }
            return new StaticMap5(this, path, route);
        }

        @Override
        public StaticRoute get(String path) {
            if (this.pattern1.equals(path)) {
                return this.route1;
            }
            if (this.pattern2.equals(path)) {
                return this.route2;
            }
            if (this.pattern3.equals(path)) {
                return this.route3;
            }
            if (this.pattern4.equals(path)) {
                return this.route4;
            }
            return null;
        }
    }

    private static class StaticMap3
    implements StaticMap {
        private String pattern1;
        private StaticRoute route1;
        private String pattern2;
        private StaticRoute route2;
        private String pattern3;
        private StaticRoute route3;

        public StaticMap3(StaticMap2 staticMap, String path, StaticRoute route) {
            this.pattern1 = staticMap.pattern1;
            this.route1 = staticMap.route1;
            this.pattern2 = staticMap.pattern2;
            this.route2 = staticMap.route2;
            this.pattern3 = path;
            this.route3 = route;
            staticMap.release();
        }

        public void release() {
            this.pattern1 = null;
            this.route1 = null;
            this.pattern2 = null;
            this.route2 = null;
            this.pattern3 = null;
            this.route3 = null;
        }

        @Override
        public StaticMap put(String path, StaticRoute route) {
            if (this.pattern1.equals(path)) {
                this.route1 = route;
                return this;
            }
            if (this.pattern2.equals(path)) {
                this.route2 = route;
                return this;
            }
            if (this.pattern3.equals(path)) {
                this.route3 = route;
                return this;
            }
            return new StaticMap4(this, path, route);
        }

        @Override
        public StaticRoute get(String path) {
            if (this.pattern1.equals(path)) {
                return this.route1;
            }
            if (this.pattern2.equals(path)) {
                return this.route2;
            }
            if (this.pattern3.equals(path)) {
                return this.route3;
            }
            return null;
        }
    }

    private static class StaticMap2
    implements StaticMap {
        private String pattern1;
        private StaticRoute route1;
        private String pattern2;
        private StaticRoute route2;

        public StaticMap2(StaticMap1 staticMap, String path, StaticRoute route) {
            this.pattern1 = staticMap.pattern;
            this.route1 = staticMap.route;
            this.pattern2 = path;
            this.route2 = route;
            staticMap.release();
        }

        public void release() {
            this.pattern1 = null;
            this.route1 = null;
            this.pattern2 = null;
            this.route2 = null;
        }

        @Override
        public StaticMap put(String path, StaticRoute route) {
            if (this.pattern1.equals(path)) {
                this.route1 = route;
                return this;
            }
            if (this.pattern2.equals(path)) {
                this.route2 = route;
                return this;
            }
            return new StaticMap3(this, path, route);
        }

        @Override
        public StaticRoute get(String path) {
            if (this.pattern1.equals(path)) {
                return this.route1;
            }
            if (this.pattern2.equals(path)) {
                return this.route2;
            }
            return null;
        }
    }

    private static class StaticMap1
    implements StaticMap {
        private String pattern;
        private StaticRoute route;

        public StaticMap1(String pattern, StaticRoute route) {
            this.pattern = pattern;
            this.route = route;
        }

        @Override
        public StaticMap put(String path, StaticRoute route) {
            if (this.pattern.equals(path)) {
                this.route = route;
                return this;
            }
            return new StaticMap2(this, path, route);
        }

        public void release() {
            this.pattern = null;
            this.route = null;
        }

        @Override
        public StaticRoute get(String path) {
            if (this.pattern.equals(path)) {
                return this.route;
            }
            return null;
        }
    }
}

